// SOCEDA integration
// ----------------
// -- EventCloud --
// ----------------

//TODO: !! Official ec will be used when inria will provide a stable ec release with dl link !!
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var ecComponentKey = "ec";
var ecConfigFilename = "ec.config.properties";

function runEC() {
	println("Checking EventCloud installation ... ");

	// Check if already installed
	var ecDir = new File(instDir, ecComponentKey);
	if (!ecDir.exists() || ecDir.listFiles().length == 0) {
		println("EventCloud not found, trying to install ...");
		ecDir.mkdir();

		// Check if the installer is in origin
		var ecInstallerFile = new File(originDir, findInstallerNameOfComponent(ecComponentKey));
		if (!ecInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(ecComponentKey);
			println("Trying to download the EventCloud installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, ecInstallerFile);
			} catch (e) {
				println("Unable to download the EventCloud installer due to " + e.javaException);
			}
			
			if (!ecInstallerFile.exists()) {
				throw "Unable to find " + ecInstallerFile + " please download "
				+ ecInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract EC binaries from the installer package
		try {
			extractFolder(ecInstallerFile, ecDir);
		} catch (e) {
			println("Unable to extract EventCloud binaries " + e.javaStackTrace);
		}
		
		if (ecDir.listFiles().length == 0) {
			throw "Unable to extract EventCloud please extract " + ecInstallerFile + " manually into " + ecDir;
		}
		
		println("Installation successfull ...");
	}

///////////////////////////////////////////////
// 
//  !!!! OLD OFFICIAL EC LAUNCH CONFIG !!!!
// 
///////////////////////////////////////////////
//	// Running EC from bin dir
//	var cmd = [ javaExe, '-cp' ];
//	println("test !");
//	// To collect classpath list all jars in lib 
//	var libDir = new File(ecDir, "lib");
//	var libs = libDir.listFiles();
//	var classpath = new StringBuilder();
//	for (var i=0; i < libs.length; i++) {
//		classpath.append("lib"+File.separator+libs[i].getName());
//		classpath.append(File.pathSeparator);
//	}
//	cmd.push(classpath);
//	
//	cmd.push("-Deventcloud.ws.start.port=9000");
//	cmd.push("-Dproactive.communication.protocol=pnp");
//	cmd.push("-Dproactive.pnp.port=1150");
//	cmd.push("-Dlog4j.configuration="+ecDir.getAbsolutePath()+File.separator+"resources"+File.separator+"log4j.xml");
//	cmd.push("-Dlogback.configurationFile="+ecDir.getAbsolutePath()+File.separator+"resources"+File.separator+"logback-test.xml");
//	cmd.push("-Djava.security.policy="+ecDir.getAbsolutePath()+File.separator+"resources"+File.separator+"proactive.java.policy");
//	cmd.push('fr.inria.eventcloud.deployment.cli.launchers.EventCloudManagementWsDeployer');
//	return execCmdNewTermAsync("EventCloud", cmd, ecDir);	
	
	var binDir = new File(ecDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, ecConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	deleteLockedFile(binDir);

	// Running ec from bin dir
	// java -jar eventcloud-mocked.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'eventcloud-mocked.jar', 'start');
	return execCmdNewTermAsync("EventCloud", cmd, binDir);
	
}