// SOCEDA integration
// ---------------
// -- EasierGOV --
// ---------------

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var govComponentKey = "gov";
var govConfigFilename = "gov.config.properties";

function runGOV() {
	println("Checking EasierGOV installation ... ");

	// Check if already installed
	var govDir = new File(instDir, govComponentKey);
	if (!govDir.exists() || govDir.listFiles().length == 0) {
		println("EasierGOV not found, trying to install ...");
		govDir.mkdir();

		// Check if the installer is in origin
		var govInstallerFile = new File(originDir, findInstallerNameOfComponent(govComponentKey));
		if (!govInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(govComponentKey);
			println("Trying to download the EasierGOV installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, govInstallerFile);
			} catch (e) {
				println("Unable to download the EasierGOV installer due to " + e.javaException);
			}
			
			if (!govInstallerFile.exists()) {
				throw "Unable to find " + govInstallerFile + " please download "
				+ govInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(govInstallerFile, govDir);
		} catch (e) {
			println("Unable to extract EasierGOV binaries " + e.javaStackTrace);
		}
		
		if (govDir.listFiles().length == 0) {
			throw "Unable to extract EasierGOV please extract " + sccliInstallerFile + " manually into " + govDir;
		}
		
		println("Installation successfull ...");
	}
	
	var binDir = new File(govDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, govConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	deleteLockedFile(binDir);

	// Running gov from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server.jar', 'start');
	return execCmdNewTermAsync("EasierGOV", cmd, binDir);
}