// SOCEDA integration
// ----------------
// -- EventCloud --
// ----------------

// TODO: ADD DOWNLOAD OF INSTALLER
// TODO: ADD REMOTE INSTALL
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var ecInstallerName = "eventcloud-bundle-1.1.0.zip";
var ecInstallerUrl = "http://eventcloud.inria.fr/binaries/releases/latest/"+ecInstallerName;

function runEC() {
	println("Checking EventCloud installation ... ");

	// Check if already installed
	var ecDir = new File(instDir, "ec");
	if (!ecDir.exists() || ecDir.listFiles().length == 0) {
		println("EventCloud not found, trying to install ...");
		ecDir.mkdir();

		// Check if the installer is in origin
		var ecInstallerFile = new File(originDir, ecInstallerName);
		if (!ecInstallerFile.exists()) {
			
			// Try to download it from the web
			println("Trying to download the EventCloud installer from " + ecInstallerUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(ecInstallerUrl, ecInstallerFile);
			} catch (e) {
				println("Unable to download the EventCloud installer due to " + e.javaException);
			}
			
			if (!ecInstallerFile.exists()) {
				throw "Unable to find " + ecInstallerFile + " please download "
				+ ecInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract EC binaries from the installer package
		try {
			extractFolder(ecInstallerFile, ecDir);
		} catch (e) {
			println("Unable to extract EventCloud binaries " + e.javaStackTrace);
		}
		
		if (ecDir.listFiles().length == 0) {
			throw "Unable to extract EventCloud please extract " + ecInstallerFile + " manually into " + ecDir;
		}
		
		println("Installation successfull ...");
	}

	// Running EC from bin dir
	var cmd = [ javaExe, '-cp' ];
	
	// To collect classpath list all jars in lib 
	var libDir = new File(ecDir, "lib");
	var libs = libDir.listFiles();
	var classpath = new StringBuilder();
	for (var i=0; i < libs.length; i++) {
		classpath.append("lib"+File.separator+libs[i].getName());
		classpath.append(File.pathSeparator);
	}
	cmd.push(classpath);
	
	cmd.push("-Deventcloud.ws.start.port=9000");
	cmd.push("-Dproactive.communication.protocol=pnp");
	cmd.push("-Dproactive.pnp.port=1150");
	cmd.push("-Dlog4j.configuration="+ecDir.getAbsolutePath()+File.separator+"resources"+File.separator+"log4j.xml");
	cmd.push("-Dlogback.configurationFile="+ecDir.getAbsolutePath()+File.separator+"resources"+File.separator+"logback-test.xml");
	cmd.push("-Djava.security.policy="+ecDir.getAbsolutePath()+File.separator+"resources"+File.separator+"proactive.java.policy");
	cmd.push('fr.inria.eventcloud.deployment.cli.launchers.EventCloudManagementWsDeployer');
	return execCmdNewTermAsync("EventCloud", cmd, ecDir, ecMachine);      
}