// SOCEDA integration
// --------
// -- WS --
// --------

// will run start-providers.sh.bat

// TODO: ADD DOWNLOAD OF INSTALLER
// TODO: ADD REMOTE INSTALL
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var wsInstallerName = "crisis-management-resources-1.0-SNAPSHOT.zip";
var wsInstallerUrl = "http://eventcloud.inria.fr/binaries/"+ecInstallerName;

function runWS() {
	println("Checking WS installation ... ");

	// Check if already installed
	var wsDir = new File(instDir, "ws");
	if (!wsDir.exists() || wsDir.listFiles().length == 0) {
		println("WS not found, trying to install ...");
		wsDir.mkdir();

		// Check if the installer is in origin
		var wsInstallerFile = new File(originDir, wsInstallerName);
		if (!wsInstallerFile.exists()) {
//			
//			// Try do download it from the web
//			println("Trying to download the WS installer from " + wsInstallerUrl);
//			println("Please wait ...");
//			try {
//				downloadFromHttp(wsInstallerUrl, wsInstallerFile);
//			} catch (e) {
//				println("Unable to download the WS installer " + e.javaStackTrace);
//			}
//			
			if (!wsInstallerFile.exists()) {
				throw "Unable to find " + wsInstallerFile + " please download "
				+ wsInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(wsInstallerFile, wsDir);
		} catch (e) {
			println("Unable to extract WS binaries " + e.javaStackTrace);
		}
		
		if (wsDir.listFiles().length == 0) {
			throw "Unable to extract WS please extract " + wsInstallerFile + " manually into " + wsDir;
		}
		
		println("Installation successfull ...");
	}

	var binDir = new File(wsDir, "bin");
	
	// Running ws from bin dir
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	
	var providerNames = [];
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.MotoristProviderEvent_WSOUIServer");
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.MotoristProvider_WSOUIServer");
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.DriverProviderEvent_WSOUIServer");
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.DriverProvider_WSOUIServer");
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.BusProviderEvent_WSOUIServer");
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.BusProvider_WSOUIServer");
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.CarProviderEvent_WSOUIServer");
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.CarProvider_WSOUIServer");
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.VehicleProviderEvent_WSOUIServer");
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.VehicleProvider_WSOUIServer");
	providerNames.push("org.petalslink.officeofinfrastructure.OfficeOfInfrastructureEventProducer_WSOUIServer");
	providerNames.push("org.petalslink.officeofinfrastructure.OfficeOfInfrastructure_WSOUIServer");
	
	var procs = [];
	for (x in providerNames) {		
		var name = providerNames[x];
		var proc = execCmdNewTermAsync(name, cmd.concat("-DendpointHost=" + wsMachine, "-cp", "crisis-management-resources-1.0-SNAPSHOT.jar", name, "standalone"), binDir, wsMachine);
		procs.push(proc);
	}
	
	return procs;
}