// SOCEDA integration
// ---------------
// -- EasierGOV --
// ---------------

// TODO: ADD DOWNLOAD OF INSTALLER
// TODO: ADD REMOTE INSTALL
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var govInstallerName = "EasierGOV-installer-linux-v2012-04-18.jar";
var govInstallerUrl = "http://research-distributions.petalslink.org/experimental/easiergov/"+govInstallerName;

function runGOV() {
	println("Checking GOV installation ... ");

	// Check if already installed
	var govDir = new File(instDir, "gov");
	if (!govDir.exists() || govDir.listFiles().length == 0) {
		println("GOV not found, trying to install ...");
		govDir.mkdir();

		// Check if the installer is in origin
		var govInstallerFile = new File(originDir, govInstallerName);
		if (!govInstallerFile.exists()) {
			
			// Try do download it from the web
			println("Trying to download the GOV installer from " + govInstallerUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(govInstallerUrl, govInstallerFile);
			} catch (e) {
				println("Unable to download the GOV installer due to " + e.javaException);
			}
			
			if (!govInstallerFile.exists()) {
				throw "Unable to find " + govInstallerFile + " please download "
				+ govInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Create config file for installation
		var cfg = new File(originDir, "gov-install.cfg");
		var out = new PrintWriter(new FileWriter(cfg));
		out.println("INSTALL_PATH=" + govDir.getName());
		out.close();
		cfg.deleteOnExit();

		// Install gov package in console mode
		// java -jar origin\installer-vXXXX-XX-XX.jar -console -options .cfg
		var cmd = [ javaExe, "-jar", govInstallerFile.getAbsolutePath(),
				"-console", "-options", cfg.getAbsolutePath() ];
		execCmd(cmd, instDir, govMachine);

		println("Installation successfull ...");
	}
	
	var binDir = new File(govDir, "bin");
	var lockedFile = new File(binDir, "locked");
	
	// Check for locked file in bin dir
	if  (lockedFile.exists()) {
		lockedFile['delete']();
	}

	// Running gov from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-Dhost=' + govMachine, '-jar', 'server.jar', 'start');
	return execCmdNewTermAsync("GOV", cmd, binDir, govMachine);
}