package com.ebmwebsourcing.soceda.crisis;

import org.objectweb.fractal.api.Component;
import org.ow2.frascati.FraSCAti;
import org.ow2.frascati.soceda.api.CEPControllerInterfaces;
import org.ow2.frascati.util.FrascatiException;

import seacloud.petalslink.com.data._1.Resource;
import seacloud.petalslink.com.data._1.ResourceType;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;

import com.ebmwebsourcing.seacloud.server.DeployerResult;
import com.ebmwebsourcing.seacloud.server.SeaCloud;
import com.ebmwebsourcing.seacloud.server.SeaCloudManagementImpl;

public class CreateFramework {


	public static DeployerResult createRuntimeFrameworkFromDescriptor(String seaCloudAdminAddress,
			SeaCloud.CEP_MODE mode, ResourcesDescriptor descriptor, boolean create, boolean useCepMock, boolean useEventCloudMock)
					throws Exception {
		DeployerResult result = SeaCloudManagementImpl.createRuntimeFrameworkFromDescriptor(seaCloudAdminAddress, mode, descriptor, create, useCepMock, useEventCloudMock);
		for (Resource rsc : descriptor.getResource()) {
			if (ResourceType.CEP_ENGINE.equals(rsc.getType())) {
				if (create && !useCepMock) {
					System.out.println("---------------------------------- create DiCEPE");
					try {
						// It is necessary to make sure that the address has the form "http://localhost:9750" 
						// and not "http://localhost:9750/services/dicepe"
						// Frascati automatically adds "/services/dicepe" from the composite file (CEP-service.composite in DiCEPE-System project)
						System.setProperty("org.ow2.frascati.binding.uri.base",
								rsc.getAddress()); 

						FraSCAti frascati = FraSCAti.newFraSCAti();
						Component composite = frascati.getComposite("CEP-server.composite");
						CEPControllerInterfaces cep = frascati.getService(composite,
								"cepController", CEPControllerInterfaces.class);
						System.out.println("---------------------------------- DiCEPE created and started");

						//for test only: get registred EPL rule
						cep.getStatementById("w8QRkTbnW7ehs3b");
					} catch (FrascatiException e) {
						e.printStackTrace();
					}
				}
			}
		}
		return result;
	}
}
