package com.ebmwebsourcing.soceda.crisis;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.LogManager;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.officeofinfrastructure.OfficeOfInfrastructureEventProducer_WSOUIServer;
import org.petalslink.officeofinfrastructure.OfficeOfInfrastructure_WSOUIServer;
import org.w3c.dom.Document;

import seacloud.petalslink.com.data._1.ResourcesDescriptor;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.seacloud.client.SeaCloudClientSOAP;
import com.ebmwebsourcing.seacloud.server.SeaCloud;
import com.ebmwebsourcing.seacloud.server.SeaCloudUI;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import fr.mines_albi.nuclearcrisisevent.provider.BusProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.BusProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.CarProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.CarProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.DriverProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.DriverProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.MotoristProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.MotoristProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.VehicleProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.VehicleProvider_WSOUIServer;

public class DemoUI {

	static {
		try {
			InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("logger/easiestdemo-logging.properties");
			LogManager.getLogManager().readConfiguration(configFile);
			configFile.close();
		} catch (Exception ex)
		{
			System.out.println("WARNING: Could not open configuration file");
			System.out.println("WARNING: Logging not configured (console output only)");
		}
	}

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(seacloud.petalslink.com.data._1.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	private MotoristProviderEvent_WSOUIServer motoristProviderEvent_WSOUIServer = null;
	private MotoristProvider_WSOUIServer motoristProvider_WSOUIServer = null;
	private DriverProviderEvent_WSOUIServer driverProviderEvent_WSOUIServer = null;
	private DriverProvider_WSOUIServer driverProvider_WSOUIServer = null;
	private BusProviderEvent_WSOUIServer busProviderEvent_WSOUIServer = null;
	private BusProvider_WSOUIServer busProvider_WSOUIServer = null;
	private CarProviderEvent_WSOUIServer carProviderEvent_WSOUIServer = null;
	private CarProvider_WSOUIServer carProvider_WSOUIServer = null;
	private VehicleProviderEvent_WSOUIServer vehicleProviderEvent_WSOUIServer = null;
	private VehicleProvider_WSOUIServer vehicleProvider_WSOUIServer = null;
	private OfficeOfInfrastructureEventProducer_WSOUIServer officeOfInfrastructureEventProducer_WSOUIServer = null;
	private OfficeOfInfrastructure_WSOUIServer officeOfInfrastructure_WSOUIServer = null;


	public void startDemo(boolean activeGUI) throws Exception {
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(DefaultFramework.getInstance()).get().readDocument(Thread.currentThread().getContextClassLoader().getResource("crisis/v3/SeaCloud.wsdl"), Definitions.class));
			Endpoint ep = desc.findEndpoint("SeaCloudSOAPEndpoint");
			String seaCloudAddress = ep.getAddress();
			ResourcesDescriptor descriptor = readDescriptor(Thread.currentThread().getContextClassLoader().getResource("com/ebmwebsourcing/soceda/crisis/descriptor.xml"));

			// 1. Create Soceda framework
			SeaCloudUI seaCloud = new SeaCloudUI(seaCloudAddress, SeaCloud.CEP_MODE.ESPER, descriptor, true, true, true);					
			seaCloud.setVisible(activeGUI);
		//	SeaCloudManagementImpl.createRuntimeFrameworkFromDescriptor(seaCloudAddress, SeaCloud.CEP_MODE.ESPER, descriptor);
			

			// 2. start all business services
			startAllWebServices();


			// 3. Deploy bpel, cep rules, default subscriptions...
			SeaCloudClientSOAP cloudClient = new SeaCloudClientSOAP(seaCloudAddress);



			//// 3.1 deploy bpel
			String bpelFileName = "OperationImplementCirculationPlanProcess.bpel";
			File folder = new File("./target/test-resources/crisis/v3/");
			File bpel = new File(folder, bpelFileName);
			File[] files = folder.listFiles(new FilenameFilter() {
				public boolean accept(File dir, String name) {
					return name.endsWith("wsdl") || name.endsWith("xsd");
				}
			});
			EJaxbDeployementReport report = cloudClient.deploy(bpel, files);

//			// 4. Wait that synchronization between easigov and esb is achieved
//			EventManagerClientImplSOAP easiergovEventClient = new EventManagerClientImplSOAP("http://localhost:9738/services/eventManager");
//			FindEventProducersByTopicsResponse response = easiergovEventClient.findEventProducersByTopics(new FindEventProducersByTopicsRequest());
//			while(response.getEndpointReference().size() == 0) {
//				Thread.sleep(500);
//				System.out.println("++++++++++++++++++++++++++ response.getEndpointReference().size() = " + response.getEndpointReference().size());
//				try {
//					response = easiergovEventClient.findEventProducersByTopics(new FindEventProducersByTopicsRequest());
//				} catch(Exception e) {
//					// do nothing
//				}
//			}
//
//			System.out.println("++++++++++++++++++++++++++ epr = " + response.getEndpointReference().get(0).getAddress().getValue());
//
//			if(!activeGUI) {
//				// 4. Start crisis process
//				EJaxbBpelReport bpelReport = (EJaxbBpelReport) report.getAny();
//				System.out.println("bpelReport = " + bpelReport.getExternalEndpointsAddressesCreated());
//				OperationImplementCirculationPlanProcess client = CXFHelper.getClient(bpelReport.getExternalEndpointsAddressesCreated().get(0), OperationImplementCirculationPlanProcess.class);
//				OperationImplementCirculationPlanProcessRequest request = new OperationImplementCirculationPlanProcessRequest();
//				OperationImplementCirculationPlanProcessResponse resp = client.process(request);
//
//				System.out.println("response : " + resp.getResult());
//			}

	}

	public void startAllWebServices() throws WSOUIException {
		motoristProviderEvent_WSOUIServer = new MotoristProviderEvent_WSOUIServer();
		motoristProviderEvent_WSOUIServer.start();
		motoristProvider_WSOUIServer = new MotoristProvider_WSOUIServer();
		motoristProvider_WSOUIServer.start();
		driverProviderEvent_WSOUIServer = new DriverProviderEvent_WSOUIServer();
		driverProviderEvent_WSOUIServer.start();
		driverProvider_WSOUIServer = new DriverProvider_WSOUIServer();
		driverProvider_WSOUIServer.start();
		busProviderEvent_WSOUIServer = new BusProviderEvent_WSOUIServer();
		busProviderEvent_WSOUIServer.start();
		busProvider_WSOUIServer = new BusProvider_WSOUIServer();
		busProvider_WSOUIServer.start();
		carProviderEvent_WSOUIServer = new CarProviderEvent_WSOUIServer();
		carProviderEvent_WSOUIServer.start();
		carProvider_WSOUIServer = new CarProvider_WSOUIServer();
		carProvider_WSOUIServer.start();
		vehicleProviderEvent_WSOUIServer = new VehicleProviderEvent_WSOUIServer();
		vehicleProviderEvent_WSOUIServer.start();
		vehicleProvider_WSOUIServer = new VehicleProvider_WSOUIServer();
		vehicleProvider_WSOUIServer.start();
		officeOfInfrastructureEventProducer_WSOUIServer = new OfficeOfInfrastructureEventProducer_WSOUIServer();
		officeOfInfrastructureEventProducer_WSOUIServer.start();
		officeOfInfrastructure_WSOUIServer = new OfficeOfInfrastructure_WSOUIServer();
		officeOfInfrastructure_WSOUIServer.start();
	}


	public static ResourcesDescriptor readDescriptor(URL resource) throws Exception {
		ResourcesDescriptor rsc = null;
		InputStream is = resource.openStream();
		Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
		rsc = SOAJAXBContext.getInstance().marshallAnyType(doc, ResourcesDescriptor.class);
		is.close();
		return rsc;
	}


}
