/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.soceda.crisis;

import org.petalslink.OperationImplementCirculationPlanProcess;
import org.petalslink.OperationImplementCirculationPlanProcessRequest;
import org.petalslink.OperationImplementCirculationPlanProcessResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;

public class OperationImplementCirculationPlanProcessSOAP implements OperationImplementCirculationPlanProcess {

	protected String address = null;

	private SOAPSender soapSender;

	static{
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(org.petalslink.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}


	public OperationImplementCirculationPlanProcessSOAP(String address) {
		this.address = address;
		soapSender = new SOAPSender();
	}


	@Override
	public OperationImplementCirculationPlanProcessResponse process(
			OperationImplementCirculationPlanProcessRequest payload) {
		OperationImplementCirculationPlanProcessResponse res = null;
		try{

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.org/process");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				System.err.println("\n\nError message: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				throw new RuntimeException(XMLPrettyPrinter.prettyPrint(soapResponse));
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, OperationImplementCirculationPlanProcessResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;
	}

	
}
