package fr.mines_albi.nuclearcrisisevent.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

import com.ebmwebsourcing.easiergov.Main;

public class BusProviderEvent_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");
	
	private final static String LOGGER_FILE = "/logger.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = Main.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}

	
	private Endpoint endpointFor_BusProviderEvent = null;
	private ProviderConfiguration confEndpointFor_BusProviderEvent = null;
	private AbstractImplementationManager<?> im = null;
	
	public BusProviderEvent_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_BusProviderEvent() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":7209/busProviderEventPort");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_BusProviderEvent() {
		if(this.confEndpointFor_BusProviderEvent == null) {
			this.confEndpointFor_BusProviderEvent = createDefaultProviderConfigurationFor_BusProviderEvent();
		}
		return this.confEndpointFor_BusProviderEvent;
	}


	public void start() throws WSOUIException {
		confEndpointFor_BusProviderEvent = getProviderConfigurationFor_BusProviderEvent();
		im = new BusProviderEventImplementationManager(new BusProviderEventTestImplementation(new BusProviderEvent_ExchangeProcessor()), BusProviderEvent_WSOUIService.getWSDL_LOCATION(), confEndpointFor_BusProviderEvent);
		endpointFor_BusProviderEvent = Endpoint.publish(confEndpointFor_BusProviderEvent.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_BusProviderEvent.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_BusProviderEvent);
	}


	public void stop() {
		if(endpointFor_BusProviderEvent != null) {
			endpointFor_BusProviderEvent.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		BusProviderEvent_WSOUIServer provider = new BusProviderEvent_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_BusProviderEvent().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
