package fr.mines_albi.nuclearcrisisevent.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

import com.ebmwebsourcing.easiergov.Main;

public class DriverProvider_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");

	private final static String LOGGER_FILE = "/logger.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = Main.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}

	
	private Endpoint endpointFor_DriverProvider = null;
	private ProviderConfiguration confEndpointFor_DriverProvider = null;
	private AbstractImplementationManager<?> im = null;
	
	public DriverProvider_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_DriverProvider() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":7204/driverProviderPort");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_DriverProvider() {
		if(this.confEndpointFor_DriverProvider == null) {
			this.confEndpointFor_DriverProvider = createDefaultProviderConfigurationFor_DriverProvider();
		}
		return this.confEndpointFor_DriverProvider;
	}


	public void start() throws WSOUIException {
		confEndpointFor_DriverProvider = getProviderConfigurationFor_DriverProvider();
		im = new DriverProviderImplementationManager(new DriverProviderTestImplementation(new DriverProvider_ExchangeProcessor()), DriverProvider_WSOUIService.getWSDL_LOCATION(), confEndpointFor_DriverProvider);
		endpointFor_DriverProvider = Endpoint.publish(confEndpointFor_DriverProvider.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_DriverProvider.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_DriverProvider);
	}


	public void stop() {
		if(endpointFor_DriverProvider != null) {
			endpointFor_DriverProvider.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		DriverProvider_WSOUIServer provider = new DriverProvider_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_DriverProvider().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
