package fr.mines_albi.nuclearcrisisevent.provider;

import java.util.logging.Logger;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import fr.mines_albi.nuclearcrisisevent.provider.VehicleProvider;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;
import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.wsoui.context.WSOUIJaxbContext;
import org.petalslink.easiestdemo.wsoui.provided.notification.AbstractEventProducerNotifier;
import org.petalslink.easiestdemo.wsoui.provided.notification.SubscriptionManager;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import org.w3c.dom.Document;
import java.net.URL;
import java.util.Enumeration;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import java.lang.InterruptedException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.io.File;
@javax.jws.WebService(
	wsdlLocation = "crisis/v3/./vehicleProvider.wsdl",
	targetNamespace = "http://www.mines-albi.fr/nuclearcrisisevent/provider",
	endpointInterface = "fr.mines_albi.nuclearcrisisevent.provider.VehicleProvider",
	portName = "vehicleProviderPort",
	serviceName = "vehicleProvider")
public class VehicleProviderImplementationManager extends AbstractImplementationManager<VehicleProvider> implements VehicleProvider{

	private AbstractEventProducerNotifier eventProducer = null;
	private WSOUIJaxbContextItf context = null;

	public VehicleProviderImplementationManager(AbstractTestImplementation ti, URL wsdl) throws WSOUIException {
		super(ti, wsdl);
		context = new WSOUIJaxbContext();
		this.eventProducer = new VehicleProvider_EventProducerNotifier(this.getConfiguration(), context);
	}

	public VehicleProviderImplementationManager(AbstractTestImplementation ti, URL wsdl, ProviderConfiguration configuration) throws WSOUIException {
		super(ti, wsdl, configuration);
		context = new WSOUIJaxbContext();
		this.eventProducer = new VehicleProvider_EventProducerNotifier(this.getConfiguration(), context);
	}

	public fr.mines_albi.nuclearcrisisevent.provider.ProvideVehicleResponse provideVehicle(ProvideVehicleRequest parameters)  {
		fr.mines_albi.nuclearcrisisevent.provider.ProvideVehicleResponse response = null;
		eventProducer.sendEventBeforeProcessingRequest("provideVehicle" ,parameters);
		response = this.getTestImplementation().provideVehicle(parameters);
		if(this.isActivateGUI()) {
		  this.getGuiImplementation().setWsouiContext(context);
		  this.getGuiImplementation().setExchangeInformations("vehicleProvider", "vehicleProviderPort", "provideVehicle", parameters, response, fr.mines_albi.nuclearcrisisevent.provider.ProvideVehicleResponse.class, this.getGuiImplementation().getResponseType());
		  this.getGuiImplementation().setVisible(true);
		  synchronized(this.lock) {
			  try {				  this.lock.wait();
			  } catch(InterruptedException ie) {
				  		// do nothing
				  		ie.printStackTrace();
			  }
		  }
		 if(this.getGuiImplementation().getResponseType().equals("out")){
			  response = (fr.mines_albi.nuclearcrisisevent.provider.ProvideVehicleResponse) this.getGuiImplementation().getResponse();
		};		}
		eventProducer.sendEventBeforeSendResponse("provideVehicle" ,parameters, response);
		return response;
	}


	public fr.mines_albi.nuclearcrisisevent.provider.ProvideVehicleDriverResponse provideVehicleDriver(ProvideVehicleDriverRequest parameters)  {
		fr.mines_albi.nuclearcrisisevent.provider.ProvideVehicleDriverResponse response = null;
		eventProducer.sendEventBeforeProcessingRequest("provideVehicleDriver" ,parameters);
		response = this.getTestImplementation().provideVehicleDriver(parameters);
		if(this.isActivateGUI()) {
		  this.getGuiImplementation().setWsouiContext(context);
		  this.getGuiImplementation().setExchangeInformations("vehicleProvider", "vehicleProviderPort", "provideVehicleDriver", parameters, response, fr.mines_albi.nuclearcrisisevent.provider.ProvideVehicleDriverResponse.class, this.getGuiImplementation().getResponseType());
		  this.getGuiImplementation().setVisible(true);
		  synchronized(this.lock) {
			  try {				  this.lock.wait();
			  } catch(InterruptedException ie) {
				  		// do nothing
				  		ie.printStackTrace();
			  }
		  }
		 if(this.getGuiImplementation().getResponseType().equals("out")){
			  response = (fr.mines_albi.nuclearcrisisevent.provider.ProvideVehicleDriverResponse) this.getGuiImplementation().getResponse();
		};		}
		eventProducer.sendEventBeforeSendResponse("provideVehicleDriver" ,parameters, response);
		return response;
	}



}
