package org.petalslink.officeofinfrastructure;

import java.util.UUID;

import javax.xml.namespace.QName;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.WSOUIJaxbContextItf;
import org.petalslink.easiestdemo.wsoui.provided.notification.AbstractEventProducerNotifier;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import fr.mines_albi.nuclearcrisisevent.DemandEvent;
import fr.mines_albi.nuclearcrisisevent.ReportEvent;
import fr.mines_albi.nuclearcrisisevent.Resources;

public class OfficeOfInfrastructure_EventProducerNotifier extends AbstractEventProducerNotifier {


	private SOAPSender sender = new SOAPSender();

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(fr.mines_albi.nuclearcrisisevent.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	public OfficeOfInfrastructure_EventProducerNotifier(ProviderConfiguration configuration, WSOUIJaxbContextItf context) throws WSOUIException {
		super(configuration, context);
		this.getSubscriptionManager().setTopicSet(Thread.currentThread().getContextClassLoader().getResource("crisis/v3/EventTopicSetOffice.xml"));
		this.getSubscriptionManager().setTopicNamespace(Thread.currentThread().getContextClassLoader().getResource("crisis/v3/EventTopicNS.xml"));
	}

	@Override
	public void setPeriodEvent() {
		this.setPeriodEvent(0); // Set the period to send event (in ms).
	}


	@Override
	public Object createPeriodicallyEvent() throws WSOUIException {
		Object event = null; // TODO: create Event.
		return event;
	}


	@Override
	public Object createEventBeforeProcessingRequest(String methodName, Object request) throws WSOUIException {
		try {
			if(methodName.equals("askForResources")) {
				System.out.println("maven-wsoui request: " + request);
				//				EJaxbSubscribe subscribe = (EJaxbSubscribe) request;
				//				QName topic = WSNHelper.getQNameInSimpleTopicExpression(WSNHelper.getTopicExpressionInFilter(subscribe.getFilter()));
				//				System.out.println("maven-wsoui topic: " + topic);
				//				System.out.println("maven-wsoui topic must be equals to: demandevent");
				//				if(topic.getLocalPart().toLowerCase().equals("demandevent")) {
				DemandEvent event = new DemandEvent();
				event.setUid(UUID.randomUUID().toString());
				Resources value = new Resources();
				value.setQuantity(5.0);
				value.setType("driver");
				event.setResources(value);
				System.out.println("maven-wsoui subscribers = " + this.getSubscriptionManager().clients);
				System.out.println("maven-wsoui methodName = " + methodName);
				System.out.println("maven-wsoui request = " + request);
				System.out.println("maven-wsoui +++++++++++++++++++++++++++++++ CREATION AND SEND OF DemandEvent EVENT");

				for(String client: this.getSubscriptionManager().clients.keySet()) {
					Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement(event);
					Notify notify = WSNHelper.createNotification(client, this.getProducerAddress(), new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic"), doc);
					Document docNotif = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);	
					Document soapRequest = SOAPSender.createSOAPMessageRequest(docNotif);
					System.out.println("Notif sent by ws provider: \n" + XMLPrettyPrinter.prettyPrint(soapRequest));
					System.out.println("maven-wsoui +++++++++++++++++++++++++++++++ CREATION AND SEND OF DemandEvent EVENT to: " + client);
					this.sender.sendSoapRequest(soapRequest, client, null);
				}

				//			}
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new WSOUIException(e);
		}
		return null;
	}


	@Override
	public Object createEventBeforeSendResponse(String methodName, Object request, Object response) throws WSOUIException {
		try {
			if(methodName.equals("askForResources")) {
				System.out.println("maven-wsoui request: " + request);
				//				EJaxbSubscribe subscribe = (EJaxbSubscribe) request;
				//				QName topic = WSNHelper.getQNameInSimpleTopicExpression(WSNHelper.getTopicExpressionInFilter(subscribe.getFilter()));
				//				System.out.println("maven-wsoui topic: " + topic);
				//				System.out.println("maven-wsoui topic must be equals to: demandevent");
				//				if(topic.getLocalPart().toLowerCase().equals("demandevent")) {
				DemandEvent event = new DemandEvent();
				event.setUid(UUID.randomUUID().toString());
				Resources value = new Resources();
				value.setQuantity(5.0);
				value.setType("truck");
				event.setResources(value);
				System.out.println("maven-wsoui subscribers = " + this.getSubscriptionManager().clients);
				System.out.println("maven-wsoui methodName = " + methodName);
				System.out.println("maven-wsoui request = " + request);
				System.out.println("maven-wsoui +++++++++++++++++++++++++++++++ CREATION AND SEND OF DemandEvent EVENT");

				for(String client: this.getSubscriptionManager().clients.keySet()) {
					Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement(event);
					Notify notify = WSNHelper.createNotification(client, this.getProducerAddress(), new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic"), doc);
					Document docNotif = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);	
					Document soapRequest = SOAPSender.createSOAPMessageRequest(docNotif);
					System.out.println("Notif sent by ws provider: \n" + XMLPrettyPrinter.prettyPrint(soapRequest));
					System.out.println("maven-wsoui +++++++++++++++++++++++++++++++ CREATION AND SEND OF DemandEvent EVENT to: " + client);
					this.sender.sendSoapRequest(soapRequest, client, null);
				}

			} else if(methodName.equals("implementCirculationPlan")) {

				ReportEvent event = new ReportEvent();
				event.setUid(UUID.randomUUID().toString());
				Resources value = new Resources();
				value.setQuantity(5.0);
				value.setType("Office of insfrastructure Report");
				event.setResultMessage("Circulation Plan: Work in progress !!! ");
				System.out.println("maven-wsoui subscribers = " + this.getSubscriptionManager().clients);
				System.out.println("maven-wsoui methodName = " + methodName);
				System.out.println("maven-wsoui request = " + request);
				System.out.println("maven-wsoui +++++++++++++++++++++++++++++++ CREATION AND SEND OF ReportEvent EVENT on CirculationPlan ");

				int numberOfNotif = 0;
				
				while(numberOfNotif < 8) {

					for(String client: this.getSubscriptionManager().clients.keySet()) {
						Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement(event);
						Notify notify = WSNHelper.createNotification(client, this.getProducerAddress(), new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic"), doc);
						Document docNotif = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);	
						Document soapRequest = SOAPSender.createSOAPMessageRequest(docNotif);
						System.out.println("Notif sent by ws provider: \n" + XMLPrettyPrinter.prettyPrint(soapRequest));
						System.out.println("maven-wsoui +++++++++++++++++++++++++++++++ CREATION AND SEND OF ReportEvent EVENT on CirculationPlan to: " + client);
						this.sender.sendSoapRequest(soapRequest, client, null);
					}
					numberOfNotif++;
					Thread.sleep(200);
				}

			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new WSOUIException(e);
		}
		return null;
	}



}
