// SOCEDA integration
// ----------
// -- Main --
// ----------
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

// Load files
load("src/util.js");
load("src/c2c.js"); 
load("src/sms.js"); 
load("src/recom.js"); 
load("src/sccli.js"); // SeaCloud CLI

{
	println("--------------------------------------------");
	println("--   Welcome to MissedCalls UseCase : " + findPropertyInInstaller("installer.version") + "  --");
	println("--         http://www.soceda.org          --");
	println("--------------------------------------------");
	
	// Check current dir
	checkCurrentLocation();
	
	// Install SeaCloud CLI
	installSCCLI();
	
	// Start all web services
	var waiterThread = startAllWSs();
	
	println("Please wait until all Web Services are started ...");
	
	readStdin("Once ready press 'Enter' to bind all WSs to SOCEDA Framework ...");
    connectAllWSs();
    
    readStdin("Once ready press 'Enter' to deploy all resources of usecase (bpels and CEP rules) ...");
	deployAllResources();	
	
	readStdin("Once ready press 'Enter' to run all EDA applications ...");
	runAllEDApplications();
	
	// The main will terminate when the waiter thread terminates
	waiterThread.join();
}


function startAllWSs() {
	var c2cProcess = runC2C();
	println("Click2Call WS started ...");
	
	var smsProcess = runSMS();
	println("SendSMS WS started ...");		
	
	var recomProcess = runRECOM();
	println("Recommandation WS started ...");
	
		
	// Add hook that terminates all if the current process is killed 
	var cleaner = java.lang.Thread(function () {
		
		println("Terminating Click2Call WS ...");
		c2cProcess.destroy();
		println("Terminating SendSMS WS ...");
		smsProcess.destroy();
		println("Terminating Recommandation WS ...");
		recomProcess.destroy();
	});
	java.lang.Runtime.getRuntime().addShutdownHook(cleaner);
	
	// Add async waiter thread 
	var waiter = java.lang.Thread(function () {
		// Wait for 
		c2cProcess.waitFor();
		smsProcess.waitFor();
		recomProcess.waitFor();
	});
	waiter.start();
	return waiter;
}

function connectAllWSs() {
	var scriptFile = new File(scriptsDir, "ConnectAllWSsScript.xml");
	println("SeaCloud CLI runs " + scriptFile + " ...");
	var sccliProcess = 	runDescriptor(scriptFile);		
	sccliProcess.waitFor();	
}

function deployAllResources() {
	var scriptFile = new File(scriptsDir, "DeployAllResourcesScript.xml");
	println("SeaCloud CLI runs " + scriptFile + " ...");
	var sccliProcess = 	runDescriptor(scriptFile);		
	sccliProcess.waitFor();
}

function runAllEDApplications() {
	var scriptFile = new File(scriptsDir, "RunAllEDApplicationsScript.xml");
	println("SeaCloud CLI runs " + scriptFile + " ...");
	var sccliProcess = 	runDescriptor(scriptFile);		
	sccliProcess.waitFor();
}
