/*
 * Decompiled with CFR 0.152.
 */
package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.inEvent;

public class BatteryEvent
extends inEvent {
    protected String level;
    protected String temperature;

    public BatteryEvent() {
    }

    public BatteryEvent(String timeStamp, String uniqueId, String sequenceNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
    }

    public BatteryEvent(String timeStamp, String uniqueId, String sequenceNumber, String level, String temperature) {
        super(timeStamp, uniqueId, sequenceNumber);
        this.level = level;
        this.temperature = temperature;
    }

    public String toRDF(String AppID) {
        String str1;
        String pattern05 = AppID;
        String pattern07 = "TaxiUCBattery";
        String pattern09 = "http://streams.event-processing.org/ids/TaxiUCBattery#stream";
        String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
        String Footer = "</mt:nativeMessage>\n";
        String avaTemplate = str1 = "@prefix :        <http://events.event-processing.org/types/> .\n@prefix e:       <http://events.event-processing.org/ids/> .\n@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\ne:#3# {\ne:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\nuctelco:uniqueId \"#6#\" ;\nuctelco:level \"#10#\" ;\nuctelco:temperature \"#11#\" ;\n# but also some other data according to event format\na :#7# ;\n:endTime \"#8#\"^^xsd:dateTime ;\n:source <http://sources.event-processing.org/ids/#5##source> ;\n:stream <#9#> ; \n}\n";
        int indexSep = this.uniqueId.indexOf(58);
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
        avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
        avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
        avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
        avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ', 'T'));
        avaTemplate = avaTemplate.replaceFirst("#9#", pattern09);
        avaTemplate = avaTemplate.replaceFirst("#11#", this.level);
        avaTemplate = avaTemplate.replaceFirst("#11#", this.temperature);
        String result = Header + avaTemplate + Footer;
        return result;
    }

    public String getMessage() {
        return this.temperature;
    }

    public void setMessage(String message) {
        this.temperature = message;
    }

    public String toString() {
        return "TwitterEvent [sequenceNumber=" + this.sequenceNumber + ", timeStamp=" + this.timeStamp + ", uniqueId=" + this.uniqueId + ", deviceId=" + ", data=" + this.level + ", message=" + this.temperature + "]";
    }
}

