/*
 * Decompiled with CFR 0.152.
 */
package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.inEvent;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;

public class PresenceEvent
extends inEvent {
    private boolean status;
    private String userType;
    private String phoneNumber;

    public PresenceEvent() {
    }

    public PresenceEvent(String timeStamp, String uniqueId, String sequenceNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
    }

    public PresenceEvent(String timeStamp, String uniqueId, String sequenceNumber, boolean status, String userType, String phoneNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
        this.status = status;
        this.userType = userType;
        this.phoneNumber = phoneNumber;
    }

    public String toStringCEP1() {
        return "stream=PresenceEvent,uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber + ",timeStamp=" + this.timeStamp + ",status=" + this.status + ",userType=" + this.userType + ",phoneNumber=" + this.phoneNumber;
    }

    public String toRDF(String AppID) {
        String str1;
        String pattern05 = AppID;
        String pattern07 = "TaxiUCPresence";
        String pattern09 = "http://streams.event-processing.org/ids/TaxiUCPresence#stream";
        String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
        String Footer = "</mt:nativeMessage>\n";
        String avaTemplate = str1 = "@prefix :        <http://events.event-processing.org/types/> .\n@prefix e:       <http://events.event-processing.org/ids/> .\n@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\ne:#3# {\ne:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\nuctelco:uniqueId \"#6#\" ;\nuctelco:userType \"#10#\" ;\nuctelco:status \"#11#\" ;\nuctelco:phoneNumber \"#12#\" ;\n# but also some other data according to event format\na :#7# ;\n:endTime \"#8#\"^^xsd:dateTime ;\n:source <http://sources.event-processing.org/ids/#5##source> ;\n:stream <#9#> . \n}\n";
        int indexSep = this.uniqueId.indexOf(58);
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
        avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
        avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
        avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
        avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ', 'T'));
        avaTemplate = avaTemplate.replaceFirst("#9#", pattern09);
        avaTemplate = avaTemplate.replaceFirst("#10#", Boolean.toString(this.status));
        avaTemplate = avaTemplate.replaceFirst("#11#", this.userType);
        avaTemplate = avaTemplate.replaceFirst("#12#", this.phoneNumber);
        if (AppID == "Android") {
            return StringEscapeUtils.escapeXml((String)avaTemplate);
        }
        return Header + StringEscapeUtils.escapeXml((String)avaTemplate) + Footer;
    }

    public boolean getStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String toStringCEP() {
        return "stream=PresenceEvent,phoneNumber=" + this.phoneNumber + ",status=" + this.status + ",userType=" + this.userType + ", timeStamp=" + this.timeStamp + ",uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber;
    }

    public String toString() {
        return "PresenceEvent [uniqueId=" + this.uniqueId + ", sequenceNumber=" + this.sequenceNumber + ", timeStamp=" + this.timeStamp + ", status=" + this.status + ", userType=" + this.userType + ", phoneNumber=" + this.phoneNumber + "]";
    }

    public String toXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <PresenceEvent xmlns=\"http://www.orange.org/TaxiEventType\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<status>" + this.status + "</status>" + "<userType>" + this.userType + "</userType>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "</PresenceEvent>";
    }

    public String toWSN() {
        return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "PresenceEventTopic", "evt"), "<OrangeLabsTaxiUC:PresenceEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.orangelabs.org/taxiEventTypes\" xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<status>" + this.status + "</status>" + "<userType>" + this.userType + "</userType>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "</OrangeLabsTaxiUC:PresenceEvent>", null, null);
    }

    public static enum NetworkStatus {
        ON,
        OFF;

    }
}

