/*
 * Decompiled with CFR 0.152.
 */
package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.MultipleCEPSupport;
import com.orange.eventData.events.inEvent;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;

public class TwitterEvent
extends inEvent
implements MultipleCEPSupport {
    private static final long serialVersionUID = 1939426977290338783L;
    protected String phoneNumber = "";
    protected String userType = "";
    protected String twId = "";
    protected String message = "";
    protected String status = "";
    protected double latitude = -1.0;
    protected double longitude = -1.0;

    public TwitterEvent() {
    }

    public TwitterEvent(String timeStamp, String uniqueId, String sequenceNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
    }

    public TwitterEvent(String timeStamp, String uniqueId, String sequenceNumber, String twId, String message, String status, double latitude, double longitude) {
        super(timeStamp, uniqueId, sequenceNumber);
        this.twId = twId;
        this.message = message;
        this.status = status;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public TwitterEvent(String message) {
        this.message = message;
    }

    public TwitterEvent(String timeStamp, String uniqueId, String sequenceNumber, String phoneNumber, String userType, String twId, String message, String status, double latitude, double longitude) {
        super(timeStamp, uniqueId, sequenceNumber);
        this.phoneNumber = phoneNumber;
        this.userType = userType;
        this.twId = twId;
        this.message = message;
        this.status = status;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getTwId() {
        return this.twId;
    }

    public void setTwId(String twId) {
        this.twId = twId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String toString() {
        return "TwitterEvent [sequenceNumber=" + this.sequenceNumber + ", timeStamp=" + this.timeStamp + ", uniqueId=" + this.uniqueId + ", phoneNumber=" + this.phoneNumber + ", userType=" + this.userType + ", twId=" + this.twId + ", message=" + this.message + ", status=" + this.status + ", latitude=" + this.latitude + ", longitude=" + this.longitude + "]";
    }

    @Override
    public String toXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <TwitterEvent xmlns=\"http://www.orange.org/TaxiEventType\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "<userType>" + this.userType + "</userType>" + "<twId>" + this.twId + "</twId>" + "<message>" + this.message + "</message>" + "<status>" + this.status + "</status>" + "<latitude>" + this.latitude + "</latitude>" + "<longitude>" + this.longitude + "</longitude>" + "</TwitterEvent>";
    }

    @Override
    public String toWSN() {
        return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "TwitterEventTopic", "evt"), "<OrangeLabsTaxiUC:TwitterEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.orangelabs.org/taxiEventTypes\" xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "<userType>" + this.userType + "</userType>" + "<twId>" + this.twId + "</twId>" + "<message>" + this.message + "</message>" + "<status>" + this.status + "</status>" + "<latitude>" + this.latitude + "</latitude>" + "<longitude>" + this.longitude + "</longitude>" + "</OrangeLabsTaxiUC:TwitterEvent>", null, null);
    }

    @Override
    public String toCEP() {
        return "stream=TwitterEvent,sequenceNumber=" + this.sequenceNumber + ",timeStamp=" + this.timeStamp + ",uniqueId=" + this.uniqueId + ",phoneNumber=" + this.phoneNumber + ",userType=" + this.userType + ",twId=" + this.twId + ",message=" + this.message + ",status=" + this.status + ",latitude=" + this.latitude + ",longitude=" + this.longitude;
    }

    @Override
    public String getRDFName() {
        return "TaxiUCTwitter";
    }

    @Override
    public String toRDF(String AppID) {
        String str1;
        String pattern05 = AppID;
        String pattern07 = "TaxiUCTwitter";
        String pattern09 = "http://streams.event-processing.org/ids/TaxiUCTwitter#stream";
        String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
        String Footer = "</mt:nativeMessage>\n";
        String avaTemplate = str1 = "@prefix :        <http://events.event-processing.org/types/> .\n@prefix e:       <http://events.event-processing.org/ids/> .\n@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\ne:#3# {\ne:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\nuctelco:phoneNumber \"#15#\" ;\nuctelco:userType \"#16#\" ;\nuctelco:uniqueId \"#6#\" ;\nuctelco:twId \"#10#\" ;\nuctelco:message \"#13#\" ;\nuctelco:status \"#14#\" ;\n# but also some other data according to event format\na :#7# ;\n:endTime \"#8#\"^^xsd:dateTime ;\n:source <http://sources.event-processing.org/ids/#5##source> ;\n:stream <#9#> ; \n:location [ geo:lat \"#11#\"^^xsd:double ; geo:long \"#12#\"^^xsd:double ] .\n}\n";
        int indexSep = this.uniqueId.indexOf(58);
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
        avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
        avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
        avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
        avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ', 'T'));
        avaTemplate = avaTemplate.replaceFirst("#9#", pattern09);
        avaTemplate = avaTemplate.replaceFirst("#10#", this.twId);
        avaTemplate = avaTemplate.replaceFirst("#11#", Double.toString(this.latitude));
        avaTemplate = avaTemplate.replaceFirst("#12#", Double.toString(this.longitude));
        avaTemplate = avaTemplate.replaceFirst("#13#", this.message);
        avaTemplate = avaTemplate.replaceFirst("#14#", this.status);
        avaTemplate = avaTemplate.replaceFirst("#15#", this.phoneNumber);
        avaTemplate = avaTemplate.replaceFirst("#16#", this.userType);
        if (AppID == "Android") {
            return StringEscapeUtils.escapeXml((String)avaTemplate);
        }
        return Header + StringEscapeUtils.escapeXml((String)avaTemplate) + Footer;
    }
}

