/*
 * Decompiled with CFR 0.152.
 */
package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.MultipleCEPSupport;
import com.orange.eventData.events.inEvent;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;

public class CallEvent
extends inEvent
implements MultipleCEPSupport {
    private static final long serialVersionUID = 2776683981803582492L;
    protected String direction = "";
    protected String message = "";
    protected String callerPhoneNumber = "";
    protected String calleePhoneNumber = "";
    protected double latitude = -1.0;
    protected double longitude = -1.0;

    public CallEvent() {
    }

    public CallEvent(String timeStamp, String uniqueId, String sequenceNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
    }

    public CallEvent(String timeStamp, String uniqueId, String sequenceNumber, String direction, String message, String callerPhoneNumber, String calleePhoneNumber, double latitude, double longitude) {
        super(timeStamp, uniqueId, sequenceNumber);
        this.direction = direction;
        this.message = message;
        this.callerPhoneNumber = callerPhoneNumber;
        this.calleePhoneNumber = calleePhoneNumber;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getCalleePhoneNumber() {
        return this.calleePhoneNumber;
    }

    public void setCalleePhoneNumber(String calleePhoneNumber) {
        this.calleePhoneNumber = calleePhoneNumber;
    }

    public String getCallerPhoneNumber() {
        return this.callerPhoneNumber;
    }

    public void setCallerPhoneNumber(String callerPhoneNumber) {
        this.callerPhoneNumber = callerPhoneNumber;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String toString() {
        return "CallEvent [uniqueId=" + this.uniqueId + ", sequenceNumber=" + this.sequenceNumber + ", timeStamp=" + this.timeStamp + ", direction=" + this.direction + ", message=" + this.message + ", callerPhoneNumber=" + this.callerPhoneNumber + ", calleePhoneNumber=" + this.calleePhoneNumber + ", latitude=" + this.latitude + ", longitude=" + this.longitude + "]";
    }

    @Override
    public String toXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <CallEvent xmlns=\"http://www.orange.org/TaxiEventType\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<direction>" + this.direction + "</direction>" + "<message>" + this.message + "</message>" + "<callerPhoneNumber>" + this.callerPhoneNumber + "</callerPhoneNumber>" + "<calleePhoneNumber>" + this.calleePhoneNumber + "</calleePhoneNumber>" + "<latitude>" + this.latitude + "</latitude>" + "<longitude>" + this.longitude + "</longitude>" + "</CallEvent>";
    }

    public String toStringCEP1() {
        return "stream=CallEvent,uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber + ",timeStamp=" + this.timeStamp + ",direction=" + this.direction + ",message=" + this.message + ",callerPhoneNumber=" + this.callerPhoneNumber + ",calleePhoneNumber=" + this.calleePhoneNumber + ",latitude=" + this.latitude + ",longitude=" + this.longitude;
    }

    @Override
    public String toCEP() {
        return "stream=CallEvent,uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber + ",timeStamp=" + this.timeStamp + ",direction=" + this.direction + ",message=" + this.message + ",callerPhoneNumber=" + this.callerPhoneNumber + ",calleePhoneNumber=" + this.calleePhoneNumber + ",latitude=" + this.latitude + ",longitude=" + this.longitude;
    }

    @Override
    public String getRDFName() {
        return "TaxiUCCall";
    }

    @Override
    public String toRDF(String AppID) {
        String str1;
        String pattern07 = "TaxiUCCall";
        String pattern05 = AppID;
        String pattern09 = "http://streams.event-processing.org/ids/TaxiUCCALL#stream";
        String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
        String Footer = "</mt:nativeMessage>\n";
        String avaTemplate = str1 = "@prefix :        <http://events.event-processing.org/types/> .\n@prefix e:       <http://events.event-processing.org/ids/> .\n@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\ne:#3# {\ne:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\nuctelco:uniqueId \"#6#\" ;\nuctelco:direction \"#10#\" ;\nuctelco:message \"#11#\" ;\nuctelco:callerPhoneNumber \"#12#\" ;\nuctelco:calleePhoneNumber \"#13#\" ;\n# but also some other data according to event format\na :#7# ;\n:endTime \"#8#\"^^xsd:dateTime ;\n:source <http://sources.event-processing.org/ids/#5##source> ;\n:stream <#9#> ; \n:location [ geo:lat \"#14#\"^^xsd:double ; geo:long \"#15#\"^^xsd:double ] .\n}\n";
        int indexSep = this.uniqueId.indexOf(58);
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
        avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
        avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
        avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
        avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ', 'T'));
        avaTemplate = avaTemplate.replaceFirst("#9#", pattern09);
        avaTemplate = avaTemplate.replaceFirst("#10#", this.direction);
        avaTemplate = avaTemplate.replaceFirst("#11#", this.message);
        avaTemplate = avaTemplate.replaceFirst("#12#", this.callerPhoneNumber);
        avaTemplate = avaTemplate.replaceFirst("#13#", this.calleePhoneNumber);
        avaTemplate = avaTemplate.replaceFirst("#14#", Double.toString(this.latitude));
        avaTemplate = avaTemplate.replaceFirst("#15#", Double.toString(this.longitude));
        if (AppID == "Android") {
            return StringEscapeUtils.escapeXml((String)avaTemplate);
        }
        return Header + StringEscapeUtils.escapeXml((String)avaTemplate) + Footer;
    }

    @Override
    public String toWSN() {
        return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "CallEventTopic", "evt"), "<OrangeLabsTaxiUC:CallEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.orangelabs.org/taxiEventTypes\" xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<direction>" + this.direction + "</direction>" + "<message>" + this.message + "</message>" + "<callerPhoneNumber>" + this.callerPhoneNumber + "</callerPhoneNumber>" + "<calleePhoneNumber>" + this.calleePhoneNumber + "</calleePhoneNumber>" + "<latitude>" + this.latitude + "</latitude>" + "<longitude>" + this.longitude + "</longitude>" + "</OrangeLabsTaxiUC:CallEvent>", null, null);
    }
}

