package com.ebmwebsourcing.ws.mock.server;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;

public class SendSMSNotifier implements NotificationConsumerDecorator {

	
	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory.class
					);
		} catch(Exception e) {
			// do nothing
		}
	}

	private boolean ui = false;
	private List<EJaxbNotify> notifies = new ArrayList<EJaxbNotify>();

	public SendSMSNotifier(boolean ui) {
		this.ui = ui;
	}


	@Override
	public void notify(EJaxbNotify notify) {
		try {
			notifies.add(notify);
			
			Object payload = notify.getNotificationMessage().get(0).getMessage().getAny();

			String m = "SendSMS RECEIVED:\n";
			if(payload instanceof Element) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild(doc.adoptNode((Element) payload));
				for(int i = 0; i < doc.getDocumentElement().getChildNodes().getLength(); i++) {
				m = m +
						doc.getDocumentElement().getChildNodes().item(i).getLocalName() + " = " + doc.getDocumentElement().getChildNodes().item(i).getTextContent() + "\n" ;
				}
			}
			
			System.out.println("ui = " + ui);
			System.out.println(m);
			
			if(ui) {
				JOptionPane.showMessageDialog(null, m, "SendSMS", JOptionPane.WARNING_MESSAGE);
			}
		} catch (Exception e) {
			// do nothing
			e.printStackTrace();
		}

	}


	public List<EJaxbNotify> getNotifications() {
		return this.notifies;
	}
}
