/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.user.service;

import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupException;
import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupManager;
import com.ebmwebsourcing.webcommons.user.api.to.RoleGroupTO;
import com.ebmwebsourcing.webcommons.user.api.to.UserTO;
import com.ebmwebsourcing.webcommons.user.persistence.bo.Role;
import com.ebmwebsourcing.webcommons.user.persistence.bo.RoleGroup;
import com.ebmwebsourcing.webcommons.user.persistence.bo.User;
import com.ebmwebsourcing.webcommons.user.persistence.dao.RoleDAO;
import com.ebmwebsourcing.webcommons.user.persistence.dao.RoleGroupDAO;
import com.ebmwebsourcing.webcommons.user.persistence.dao.UserDAO;
import com.ebmwebsourcing.webcommons.user.service.CommonServiceConfig;
import com.ebmwebsourcing.webcommons.user.service.RolesAndUsersTransfertObjectAssembler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class RoleGroupManagerImplTest
extends CommonServiceConfig {
    private static String ROLE_NAME_1 = "role_1";
    private static String ROLE_NAME_2 = "role_2";
    private static String ROLE_GROUP_NAME_1 = "roleGroup1";
    private static String ROLE_GROUP_NAME_2 = "roleGroup2";
    private static String USER_NAME_1 = "user1";
    private static String USER_NAME_2 = "user2";
    private Role role1;
    private Role role2;
    private List<String> listRole;
    private RoleGroup roleGroup1;
    private RoleGroup roleGroup2;
    private User user1;
    private User user2;
    private List<UserTO> listUser;
    @Resource
    private RoleGroupManager roleGroupManager;
    @Resource
    private RolesAndUsersTransfertObjectAssembler rolesAndUsersTransfertObjectAssembler;
    @Resource
    private RoleGroupDAO roleGroupDAO;
    @Resource
    private RoleDAO roleDAO;
    @Resource
    private UserDAO userDAO;

    public void createTestData() {
        this.role1 = new Role();
        this.role1.setName(ROLE_NAME_1);
        this.role2 = new Role();
        this.role2.setName(ROLE_NAME_2);
        this.user1 = new User();
        this.user1.setName(USER_NAME_1);
        this.user1.setPassword("pass");
        this.user2 = new User();
        this.user2.setName(USER_NAME_2);
        this.user2.setPassword("pass");
        this.roleDAO.save((Object)this.role1);
        this.roleDAO.save((Object)this.role2);
        this.userDAO.save((Object)this.user1);
        this.userDAO.save((Object)this.user2);
        this.getHibernateSession().flush();
    }

    public void createUserTOData() {
        this.listUser = new ArrayList<UserTO>();
        UserTO userTO = new UserTO();
        userTO.setName(USER_NAME_1);
        this.listUser.add(userTO);
        userTO.setName(USER_NAME_2);
        this.listUser.add(userTO);
    }

    public void createRoleGroupData() {
        this.createTestData();
        this.roleGroup1 = new RoleGroup();
        this.roleGroup1.setName(ROLE_GROUP_NAME_1);
        ArrayList<Role> listRoles = new ArrayList<Role>();
        listRoles.add(this.role1);
        listRoles.add(this.role2);
        this.roleGroup1.setListRoles(listRoles);
        this.roleGroup1.addUser(this.user1);
        this.roleGroupDAO.save((Object)this.roleGroup1);
        this.getHibernateSession().flush();
    }

    public void createAllRoleGroupData() {
        this.roleGroup1 = new RoleGroup();
        this.roleGroup1.setName(ROLE_GROUP_NAME_1);
        ArrayList<Role> listRoles = new ArrayList<Role>();
        listRoles.add(this.role1);
        listRoles.add(this.role2);
        this.roleGroup1.setListRoles(listRoles);
        ArrayList<User> listUsers = new ArrayList<User>();
        listUsers.add(this.user1);
        ArrayList<RoleGroup> listRoleGroup = new ArrayList<RoleGroup>();
        listRoleGroup.add(this.roleGroup1);
        this.user2.setListRoleGroup(listRoleGroup);
        listUsers.add(this.user2);
        this.roleGroup1.setListUser(listUsers);
        this.roleGroup2 = new RoleGroup();
        this.roleGroup2.setName(ROLE_GROUP_NAME_2);
        this.roleGroup2.setListRoles(listRoles);
        listUsers.remove(this.user2);
        this.roleGroup2.setListUser(listUsers);
        this.roleGroupDAO.save((Object)this.roleGroup1);
        this.roleGroupDAO.save((Object)this.roleGroup2);
        this.getHibernateSession().flush();
    }

    public void createAllRoleGroupWithRoleNullData() {
        this.roleGroup1 = new RoleGroup();
        this.roleGroup1.setName(ROLE_GROUP_NAME_1);
        ArrayList<Role> listRoles = new ArrayList<Role>();
        listRoles.add(this.role1);
        listRoles.add(this.role2);
        this.roleGroup1.setListRoles(listRoles);
        ArrayList<User> listUsers = new ArrayList<User>();
        listUsers.add(this.user1);
        listUsers.add(this.user2);
        this.roleGroup1.setListUser(listUsers);
        this.roleGroupDAO.save((Object)this.roleGroup1);
        this.getHibernateSession().flush();
        this.roleGroup2 = new RoleGroup();
        this.roleGroup2.setName(ROLE_GROUP_NAME_2);
        listUsers.remove(this.user2);
        this.roleGroup2.setListUser(listUsers);
        this.roleGroupDAO.save((Object)this.roleGroup2);
        this.getHibernateSession().flush();
    }

    @Test
    public void testCreateRoleGroupNominal() throws RoleGroupException {
        this.createTestData();
        this.createUserTOData();
        this.listRole = new ArrayList<String>();
        this.listRole.add(ROLE_NAME_1);
        this.listRole.add(ROLE_NAME_2);
        RoleGroupTO roleGroupTO = new RoleGroupTO();
        roleGroupTO.setName(ROLE_GROUP_NAME_1);
        roleGroupTO.setListUsers(this.listUser);
        roleGroupTO.setListRoles(this.listRole);
        String id = this.roleGroupManager.createRoleGroup(roleGroupTO);
        this.getHibernateSession().flush();
        RoleGroup roleGroup = (RoleGroup)this.roleGroupDAO.get((Serializable)((Object)id));
        RoleGroupManagerImplTest.assertEquals((String)ROLE_GROUP_NAME_1, (String)roleGroup.getName());
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testCreateRoleGroupTwice() throws RoleGroupException {
        this.createUserTOData();
        this.createRoleGroupData();
        this.listRole = new ArrayList<String>();
        this.listRole.add(ROLE_NAME_1);
        this.listRole.add(ROLE_NAME_2);
        RoleGroupTO roleGroupTO = new RoleGroupTO();
        roleGroupTO.setName(ROLE_GROUP_NAME_1);
        roleGroupTO.setListUsers(this.listUser);
        roleGroupTO.setListRoles(this.listRole);
        this.roleGroupManager.createRoleGroup(roleGroupTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testCreateRoleGroupNull() throws RoleGroupException {
        RoleGroupTO roleGroupTO = new RoleGroupTO();
        this.roleGroupManager.createRoleGroup(roleGroupTO);
        this.getHibernateSession().flush();
    }

    @Test
    public void testCreateRoleGroupListRoleNull() throws RoleGroupException {
        this.createTestData();
        this.createUserTOData();
        RoleGroupTO roleGroupTO = new RoleGroupTO();
        roleGroupTO.setName(ROLE_GROUP_NAME_1);
        roleGroupTO.setListUsers(this.listUser);
        roleGroupTO.setListRoles(null);
        String id = this.roleGroupManager.createRoleGroup(roleGroupTO);
        this.getHibernateSession().flush();
        RoleGroup roleGroup = (RoleGroup)this.roleGroupDAO.get((Serializable)((Object)id));
        RoleGroupManagerImplTest.assertEquals((String)ROLE_GROUP_NAME_1, (String)roleGroup.getName());
    }

    @Test
    public void testCreateRoleGroupListUserNull() throws RoleGroupException {
        this.createTestData();
        this.listRole = new ArrayList<String>();
        this.listRole.add(ROLE_NAME_1);
        this.listRole.add(ROLE_NAME_2);
        RoleGroupTO roleGroupTO = new RoleGroupTO();
        roleGroupTO.setName(ROLE_GROUP_NAME_1);
        roleGroupTO.setListUsers(null);
        roleGroupTO.setListRoles(this.listRole);
        String id = this.roleGroupManager.createRoleGroup(roleGroupTO);
        this.getHibernateSession().flush();
        RoleGroup roleGroup = (RoleGroup)this.roleGroupDAO.get((Serializable)((Object)id));
        RoleGroupManagerImplTest.assertEquals((String)ROLE_GROUP_NAME_1, (String)roleGroup.getName());
    }

    @Test
    public void testGetAllNominal() throws RoleGroupException {
        this.createTestData();
        this.createAllRoleGroupData();
        List listRoleGroup = this.roleGroupManager.getAllRoleGroup();
        for (RoleGroupTO rG : listRoleGroup) {
            if (rG.getName().equals(ROLE_GROUP_NAME_1)) {
                RoleGroupManagerImplTest.assertEquals((String)rG.getName(), (String)this.roleGroup1.getName());
            }
            if (!rG.getName().equals(ROLE_GROUP_NAME_2)) continue;
            RoleGroupManagerImplTest.assertEquals((String)rG.getName(), (String)this.roleGroup2.getName());
        }
    }

    @Test
    public void testGetAllRoleGroupNull() throws RoleGroupException {
        this.createTestData();
        this.createAllRoleGroupWithRoleNullData();
        List listRoleGroup = this.roleGroupManager.getAllRoleGroup();
        for (RoleGroupTO rG : listRoleGroup) {
            if (rG.getName().equals(ROLE_GROUP_NAME_1)) {
                RoleGroupManagerImplTest.assertEquals((String)rG.getName(), (String)this.roleGroup1.getName());
            }
            if (!rG.getName().equals(ROLE_GROUP_NAME_2)) continue;
            RoleGroupManagerImplTest.assertEquals((String)rG.getName(), (String)this.roleGroup2.getName());
        }
    }

    @Test
    public void testGetAllNotInUser() throws RoleGroupException {
        this.createTestData();
        this.createAllRoleGroupData();
        String idUser = this.user2.getId();
        List listRoleGroup = this.roleGroupManager.getRoleGroupNotInUser(idUser);
        for (RoleGroupTO rG : listRoleGroup) {
            RoleGroupManagerImplTest.assertEquals((String)ROLE_GROUP_NAME_2, (String)rG.getName());
        }
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testGetAllNotInUserIdUserNull() throws RoleGroupException {
        String idUser = "none";
        this.roleGroupManager.getRoleGroupNotInUser(idUser);
    }

    @Test
    public void testGetRoleGroupNominal() throws RoleGroupException {
        this.createRoleGroupData();
        String id = this.roleGroup1.getId();
        RoleGroupTO roleGroup = this.roleGroupManager.getRoleGroup(id);
        RoleGroupManagerImplTest.assertEquals((String)ROLE_GROUP_NAME_1, (String)roleGroup.getName());
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testGetRoleGroupIdNull() throws RoleGroupException {
        String id = "none";
        this.roleGroupManager.getRoleGroup(id);
    }

    @Test
    public void testRemoveNominal() throws RoleGroupException {
        this.createRoleGroupData();
        String id = this.roleGroup1.getId();
        this.roleGroupManager.removeRoleGroup(id);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testRemoveIdRoleGroupNull() throws RoleGroupException {
        String id = "none";
        this.roleGroupManager.removeRoleGroup(id);
        this.getHibernateSession().flush();
    }

    @Test
    public void testUpdateNominal() throws RoleGroupException {
        this.createRoleGroupData();
        RoleGroupTO roleGroup = this.rolesAndUsersTransfertObjectAssembler.toRoleGroupTO(this.roleGroup1);
        String name = "Test name";
        roleGroup.setName(name);
        this.roleGroupManager.updateRoleGroup(roleGroup);
        this.getHibernateSession().flush();
        RoleGroupManagerImplTest.assertEquals((String)roleGroup.getId(), (String)this.roleGroup1.getId());
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testUpdateRoleGroupTwice() throws RoleGroupException {
        this.createTestData();
        this.createAllRoleGroupData();
        RoleGroupTO roleGroup = this.rolesAndUsersTransfertObjectAssembler.toRoleGroupTO(this.roleGroup1);
        String name = ROLE_GROUP_NAME_2;
        roleGroup.setName(name);
        this.roleGroupManager.updateRoleGroup(roleGroup);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testUpdateRoleGroupIdNull() throws RoleGroupException {
        RoleGroupTO roleGroup = new RoleGroupTO();
        this.roleGroupManager.updateRoleGroup(roleGroup);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testUpdateRoleGroupNameNull() throws RoleGroupException {
        this.createRoleGroupData();
        RoleGroupTO roleGroup = this.rolesAndUsersTransfertObjectAssembler.toRoleGroupTO(this.roleGroup1);
        String name = null;
        roleGroup.setName(name);
        this.roleGroupManager.updateRoleGroup(roleGroup);
        this.getHibernateSession().flush();
    }

    @Test
    public void testUpdateListRoleNull() throws RoleGroupException {
        this.createRoleGroupData();
        RoleGroupTO roleGroup = this.rolesAndUsersTransfertObjectAssembler.toRoleGroupTO(this.roleGroup1);
        roleGroup.setListRoles(null);
        this.roleGroupManager.updateRoleGroup(roleGroup);
        this.getHibernateSession().flush();
        RoleGroupManagerImplTest.assertEquals((String)roleGroup.getId(), (String)this.roleGroup1.getId());
    }

    @Test
    public void testUpdateListUserNull() throws RoleGroupException {
        this.createRoleGroupData();
        RoleGroupTO roleGroup = this.rolesAndUsersTransfertObjectAssembler.toRoleGroupTO(this.roleGroup1);
        roleGroup.setListUsers(null);
        this.roleGroupManager.updateRoleGroup(roleGroup);
        this.getHibernateSession().flush();
        RoleGroupManagerImplTest.assertEquals((String)roleGroup.getId(), (String)this.roleGroup1.getId());
    }

    @Test
    public void testAddUserNominal() throws RoleGroupException {
        this.createRoleGroupData();
        this.roleGroupManager.addUser(this.user2.getId(), this.roleGroup1.getId());
        this.getHibernateSession().flush();
        RoleGroupManagerImplTest.assertNotNull((Object)this.roleGroup1.getListUser());
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testAddUserIdUserNull() throws RoleGroupException {
        this.createRoleGroupData();
        this.roleGroupManager.addUser("none", this.roleGroup1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testAddUserIdRoleGroupNull() throws RoleGroupException {
        this.createRoleGroupData();
        this.roleGroupManager.addUser(this.user2.getId(), "none");
        this.getHibernateSession().flush();
    }

    @Test
    public void testRemoveUserNominal() throws RoleGroupException {
        this.createRoleGroupData();
        this.roleGroupManager.removeUser(this.user1.getId(), this.roleGroup1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testRemoveUserIdUserNull() throws RoleGroupException {
        this.createRoleGroupData();
        this.roleGroupManager.removeUser("none", this.roleGroup1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=RoleGroupException.class)
    public void testRemoveUserIdRoleGroupNull() throws RoleGroupException {
        this.createRoleGroupData();
        this.roleGroupManager.removeUser(this.user2.getId(), "none");
        this.getHibernateSession().flush();
    }

    @Test
    public void testRemoveRoleWithUser() throws RoleGroupException {
        this.createRoleGroupData();
        this.roleGroupManager.removeRoleGroup(this.roleGroup1.getId());
        this.getHibernateSession().flush();
    }
}

