/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.user.service;

import com.ebmwebsourcing.webcommons.user.api.service.UserRoleManager;
import com.ebmwebsourcing.webcommons.user.api.to.RoleGroupTO;
import com.ebmwebsourcing.webcommons.user.persistence.bo.Role;
import com.ebmwebsourcing.webcommons.user.persistence.bo.RoleGroup;
import com.ebmwebsourcing.webcommons.user.persistence.bo.User;
import com.ebmwebsourcing.webcommons.user.persistence.bo.UserRole;
import com.ebmwebsourcing.webcommons.user.persistence.dao.RoleGroupDAO;
import com.ebmwebsourcing.webcommons.user.persistence.dao.UserRoleDAO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class UserRoleManagerImpl
implements UserRoleManager {
    private UserRoleDAO userRoleDAO;
    private RoleGroupDAO roleGroupDAO;

    @Override
    public void addRoles(User user, RoleGroup roleGroup) {
        for (Role r : roleGroup.getListRoles()) {
            UserRole uR = this.userRoleDAO.getRoleGroupByName(user.getName(), r.getName());
            if (uR != null) continue;
            uR = new UserRole();
            uR.setRole_name(r.getName());
            uR.setName(user.getName());
            this.userRoleDAO.save(uR);
        }
    }

    @Override
    public void saveUserRole(User user) {
        if (user.getId() == null) {
            UserRole userRole = new UserRole();
            userRole.setRole_name("ROLE_AUTH");
            userRole.setName(user.getName());
            this.userRoleDAO.save(userRole);
        }
        ArrayList<String> listRole = new ArrayList<String>();
        if (user.getListRoleGroup() != null && !user.getListRoleGroup().isEmpty()) {
            for (RoleGroup rG : user.getListRoleGroup()) {
                RoleGroup rGTmp = (RoleGroup)((Object)this.roleGroupDAO.get((Serializable)((Object)rG.getId())));
                for (Role role : rGTmp.getListRoles()) {
                    listRole.add(role.getName());
                }
            }
            for (int i = 0; i < listRole.size(); ++i) {
                int j = i + 1;
                while (j < listRole.size()) {
                    if (((String)listRole.get(i)).equalsIgnoreCase((String)listRole.get(j))) {
                        listRole.remove(j);
                        continue;
                    }
                    ++j;
                }
            }
            for (String roleName : listRole) {
                UserRole userRole = new UserRole();
                userRole.setRole_name(roleName);
                userRole.setName(user.getName());
                this.userRoleDAO.save(userRole);
            }
        }
    }

    @Override
    public void updateOrRemoveRoleForUser(RoleGroup roleGroup, RoleGroupTO roleGroupTO) {
        ArrayList<String> listRolesTmp;
        ArrayList<String> listRoles = new ArrayList<String>();
        for (Role r : roleGroup.getListRoles()) {
            listRoles.add(r.getName());
        }
        if (listRoles != null && !listRoles.isEmpty()) {
            if (roleGroupTO.getListRoles() != null && !roleGroupTO.getListRoles().isEmpty()) {
                int j;
                int i;
                listRolesTmp = new ArrayList();
                listRolesTmp.addAll(roleGroupTO.getListRoles());
                for (i = 0; i < listRoles.size(); ++i) {
                    for (j = 0; j < listRolesTmp.size(); ++j) {
                        if (!((String)listRoles.get(i)).equalsIgnoreCase((String)listRolesTmp.get(j))) continue;
                        listRolesTmp.remove(j);
                    }
                }
                this.addNewRole(roleGroup, listRolesTmp);
                listRolesTmp.clear();
                listRolesTmp.addAll(roleGroupTO.getListRoles());
                for (i = 0; i < listRolesTmp.size(); ++i) {
                    for (j = 0; j < listRoles.size(); ++j) {
                        if (!((String)listRolesTmp.get(i)).equalsIgnoreCase((String)listRoles.get(j))) continue;
                        listRoles.remove(j);
                    }
                }
                this.removeRoleUser(listRoles, roleGroup);
            } else {
                this.removeRoleUser(listRoles, roleGroup);
            }
        } else {
            listRolesTmp = new ArrayList<String>();
            listRolesTmp.addAll(roleGroupTO.getListRoles());
            this.addNewRole(roleGroup, listRolesTmp);
        }
    }

    private void addNewRole(RoleGroup roleGroup, List<String> roles) {
        for (User us : roleGroup.getListUser()) {
            for (String r : roles) {
                UserRole userRole = this.userRoleDAO.getRoleGroupByName(us.getName(), r);
                if (userRole != null) continue;
                userRole = new UserRole();
                userRole.setRole_name(r);
                userRole.setName(us.getName());
                this.userRoleDAO.save(userRole);
            }
        }
    }

    private void removeRoleUser(List<String> listRoles, RoleGroup roleGroup) {
        for (User us : roleGroup.getListUser()) {
            List<RoleGroup> listRoleGroup = us.getListRoleGroup();
            ArrayList<Role> listR = new ArrayList<Role>();
            for (RoleGroup rG : listRoleGroup) {
                if (rG.getName().equalsIgnoreCase(roleGroup.getName())) continue;
                listR.addAll(rG.getListRoles());
            }
            for (Role r : listR) {
                for (int i = 0; i < listRoles.size(); ++i) {
                    if (!r.getName().equalsIgnoreCase(listRoles.get(i))) continue;
                    listRoles.remove(i);
                }
            }
            for (String rS : listRoles) {
                UserRole uR = this.userRoleDAO.getRoleGroupByName(us.getName(), rS);
                this.userRoleDAO.remove(uR);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeRoles(User user, RoleGroup roleGroup) {
        if (user.getListRoleGroup() != null && !user.getListRoleGroup().isEmpty()) {
            for (RoleGroup rg : user.getListRoleGroup()) {
                ArrayList<String> listRS;
                if (!rg.getName().equalsIgnoreCase(roleGroup.getName())) {
                    void var7_12;
                    listRS = new ArrayList<String>();
                    for (Role role : rg.getListRoles()) {
                        listRS.add(role.getName());
                    }
                    ArrayList<String> listRSTmp = new ArrayList<String>();
                    for (Role r : roleGroup.getListRoles()) {
                        listRSTmp.add(r.getName());
                    }
                    boolean bl = false;
                    while (var7_12 < listRS.size()) {
                        for (int j = 0; j < listRSTmp.size(); ++j) {
                            if (!((String)listRS.get((int)var7_12)).equalsIgnoreCase((String)listRSTmp.get(j))) continue;
                            listRSTmp.remove(j);
                        }
                        ++var7_12;
                    }
                    for (String r : listRSTmp) {
                        UserRole uR = this.userRoleDAO.getRoleGroupByName(user.getName(), r);
                        this.userRoleDAO.remove(uR);
                    }
                    continue;
                }
                if (!rg.getName().equalsIgnoreCase(roleGroup.getName()) || user.getListRoleGroup().size() != 1) continue;
                listRS = new ArrayList();
                for (Role role : rg.getListRoles()) {
                    listRS.add(role.getName());
                }
                for (String string : listRS) {
                    UserRole uR = this.userRoleDAO.getRoleGroupByName(user.getName(), string);
                    this.userRoleDAO.remove(uR);
                }
            }
        }
    }

    @Override
    public void removeUserRole(User user) {
        List<UserRole> allUserRoles = this.userRoleDAO.getAllByUserName(user.getName());
        for (int i = 0; i < allUserRoles.size(); ++i) {
            UserRole uR = allUserRoles.get(i);
            this.userRoleDAO.remove(uR);
        }
    }

    public void setUserRoleDAO(UserRoleDAO userRoleDAO) {
        this.userRoleDAO = userRoleDAO;
    }

    public void setRoleGroupDAO(RoleGroupDAO roleGroupDAO) {
        this.roleGroupDAO = roleGroupDAO;
    }
}

