/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.legacy.jaxb.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.SchemaFactory;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public final class SchemaJAXBContext {


	private final List<Class> defaultObjectFactories = new ArrayList<Class>(Arrays.asList(new Class[] {
			}));


	private List<Class> currentObjectFactories = new ArrayList<Class>(defaultObjectFactories);

	/**
	 * The JAXB context
	 */
	private JAXBContext jaxbContext;

	private static SchemaJAXBContext instance = null;
	private static SchemaException fail = null;

	static {
		try {
			instance = new SchemaJAXBContext();
		} catch (SchemaException e) {
			fail = e;
		}
	}


	/**
	 * Private object initializations
	 */
	private SchemaJAXBContext() throws SchemaException {
		SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

		// The EndpointReference parent resource is in the Jar where the class
		// is
		// loaded
		try {
			this.jaxbContext = JAXBContext
			.newInstance(currentObjectFactories.toArray(new Class[currentObjectFactories.size()]));

		} catch (final JAXBException e) {
			throw new SchemaException(e);
		}

	}

	public static SchemaJAXBContext getInstance() throws SchemaException {
		if(fail == null) {
			return instance;
		} else {
			throw fail;
		}
	}



	public synchronized void addOtherObjectFactory(List<Class> addedObjectFactories) throws SchemaException {
		if(addedObjectFactories != null) {

			for(Class clazz : addedObjectFactories){

				if(!currentObjectFactories.contains(clazz)){
					currentObjectFactories.add(clazz);
				}
			}

			try {
				//factory.newSchema(new StreamSource[] { new StreamSource(schemaUrl11.openStream()) });

				this.jaxbContext = JAXBContext
				.newInstance(currentObjectFactories.toArray(new Class[currentObjectFactories.size()]));

			} catch (final JAXBException e) {
				throw new SchemaException(e);
			}
		}
	}


	/**
	 * @return the jaxbContext
	 */
	public synchronized JAXBContext getJaxbContext() {
		return this.jaxbContext;
	}
}
