/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.legacy.jaxb.core;

import java.util.StringTokenizer;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class EasyXMLFilter extends XMLFilterImpl {

	private boolean first=true;
	
	private SchemaLocatorImpl schemaLocator = new SchemaLocatorImpl();
	
	private NamespaceMapperImpl namespaceContext = new NamespaceMapperImpl();
	
	public EasyXMLFilter(XMLReader parent) {
		super(parent);
	}

	@Override
	public void startElement(String uri, String localName, String name,
			Attributes atts) throws SAXException {
		if (first){
			String schemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
			if (schemaLocation!=null){
				for (StringTokenizer stringTokenizer = new StringTokenizer(schemaLocation); stringTokenizer.hasMoreTokens(); ){
					String schemaUri = stringTokenizer.nextToken();
					if (stringTokenizer.hasMoreTokens()){
						String location = stringTokenizer.nextToken();
						schemaLocator.addSchemaLocation(schemaUri,location);
					}
				}
			}
			first = false;
		}
		super.startElement(uri, localName, name, atts);
	}

	@Override
	public void startPrefixMapping(String prefix, String uri)
			throws SAXException {
		namespaceContext.addNamespace(prefix, uri);
		super.startPrefixMapping(prefix, uri);
	}
	
	
	@Override
	public void startDocument() throws SAXException {
		first = true;
		super.startDocument();
	}

	public SchemaLocatorImpl getSchemaLocator() {
		return schemaLocator;
	}

	public NamespaceMapperImpl getNamespaceMapper() {
		return namespaceContext;
	}

}
