/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.ebmwebsourcing.wsstar.addressing.definition.decorator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfEndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SchemaException;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@SuppressWarnings("unchecked")
public abstract class AbstractAddressingConverter<
EprNew extends AbsItfEndpointReferenceType, EprImpl extends DecoratorEndpointReferenceTypeImpl,
RefNew extends AbsItfReferenceParametersType, RefImpl extends DecoratorReferenceParametersTypeImpl> {


	public AbstractAddressingConverter() {
	}


	public abstract EprNew convertEndpointReferenceType(AbsItfEndpointReferenceType desc) throws WSAddressingException;


	protected EprNew convertEndpointReferenceType(final AbsItfEndpointReferenceType odlDesc, final Class<EprImpl> eprimpl,
			final Class<RefImpl> refimpl)
	throws WSAddressingException {
		EprNew newEpr = null;
		try {
			// create new description
			newEpr = this.convertEndpointReferenceType(odlDesc, eprimpl);

			// add reference parameters type
			if (odlDesc.getReferenceParameters() != null){
				RefNew newRef = this.convertReferenceParametersType(odlDesc.getReferenceParameters(), refimpl);
				newEpr.setReferenceParameters(newRef);
			}


		} catch (final IllegalArgumentException e) {
			throw new WSAddressingException(e);
		} catch (final SchemaException e) {
			throw new WSAddressingException(e);
		}
		return newEpr;
	}


	private EprNew convertEndpointReferenceType(final AbsItfEndpointReferenceType odlDesc, final Class<EprImpl> eprimpl)
	throws WSAddressingException {
		EprNew newDesc = null;
		try {
			// create new description
			final Constructor c = eprimpl.getConstructors()[0];
			newDesc = (EprNew) c.newInstance(odlDesc);
		} catch (final IllegalArgumentException e) {
			throw new WSAddressingException(e);
		} catch (final InstantiationException e) {
			throw new WSAddressingException(e);
		} catch (final IllegalAccessException e) {
			throw new WSAddressingException(e);
		} catch (final InvocationTargetException e) {
			throw new WSAddressingException(e);
		}
		return newDesc;
	}

	/**
	 * Convert all wsdl element
	 */
	private RefNew convertReferenceParametersType(final AbsItfReferenceParametersType oldRef, final Class<RefImpl> refimpl)
	throws WSAddressingException {
		RefNew newRef = null;
		try {
			final Constructor c = refimpl.getConstructors()[0];
			newRef = (RefNew) c.newInstance((AbsItfReferenceParametersType)oldRef);
		} catch (final IllegalArgumentException e) {
			throw new WSAddressingException(e);
		} catch (final InstantiationException e) {
			throw new WSAddressingException(e);
		} catch (final IllegalAccessException e) {
			throw new WSAddressingException(e);
		} catch (final InvocationTargetException e) {
			throw new WSAddressingException(e);
		}
		return newRef;
	}


}
