/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.addressing.definition.test;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SchemaException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;

public class WSAddressingDescriptorTest
extends TestCase {
    private String TARGET_NAMESPACE = "http://petals.ow2.org/";

    public QName cName(String name) {
        return new QName(this.TARGET_NAMESPACE, name);
    }

    public WSAddressingDescriptorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReaderAddressing() throws URISyntaxException, WSAddressingException {
        EndpointReferenceType desc = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(new URI("./src/test/resources/descriptors/endpoint.xml"));
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((String)"testEndpoint", (String)desc.getAddress());
        Assert.assertEquals((int)1, (int)desc.getPolicies().size());
        System.out.println(desc);
        System.out.println(desc.getAddress());
        System.out.println(desc.getPolicies().size());
    }

    public void testWriterAddressing() throws SchemaException, URISyntaxException, SchemaException {
        EndpointReferenceType desc = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(new URI("./src/test/resources/descriptors/endpoint.xml"));
        String res = WSAddressingFactory.getInstance().newWSAddressingWriter().writeEndpointReferenceType(desc);
        Assert.assertNotNull((Object)res);
        System.out.println("xml plat:\n" + res);
        Document doc = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
    }

    public void testCreateAddressing() throws URISyntaxException, SchemaException {
        EndpointReferenceType desc = WSAddressingFactory.getInstance().newEndpointReferenceType();
        desc.setTagQName(new QName("http://petals.ow2.org", "MyEndpoint"));
        desc.setAddress("myEndpointAddress");
        Assert.assertNotNull((Object)desc);
        Document doc = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
    }

    public void testPersistAndRestoreEndpointReference() {
        try {
            File[] storedRegFiles;
            String tempDirName = "tmp" + File.separatorChar;
            String persistenceRepositoryName = tempDirName + "SaveEndpointReference" + File.separatorChar;
            File persistenceRepository = new File(persistenceRepositoryName);
            persistenceRepository.mkdirs();
            EndpointReferenceType desc = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(new URI("./src/test/resources/descriptors/EndpointReference.xml"));
            File fileToSaveTo = new File(persistenceRepositoryName + UUID.randomUUID().toString());
            WSAddressingFactory.getInstance().newWSAddressingWriter().writeEndpointReferenceType(desc, fileToSaveTo);
            if (persistenceRepository.exists() && persistenceRepository.isDirectory()) {
                File[] persistedSubscriptions = persistenceRepository.listFiles();
                Document docRep = null;
                System.out.println(" ########### List of restored Endpoint : ###########");
                for (int i = 0; i < persistedSubscriptions.length; ++i) {
                    EndpointReferenceType restoredEdp = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(persistedSubscriptions[i]);
                    docRep = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(restoredEdp);
                }
                System.out.println(" ########### Fin de List  ###########");
            }
            for (File fileItem : storedRegFiles = persistenceRepository.listFiles()) {
                fileItem.delete();
            }
            persistenceRepository.delete();
            new File(tempDirName).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

