/**
 * easySchema - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.ebmwebsourcing.wsstar.addressing.definition.impl;

import javax.xml.namespace.QName;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class Constants {

    /**
     * SchemaImpl Namespace
     */
    public static final String WSADDRESSING_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    
    public static final String WSADDRESSING_PREFIX = "wsa";
    
    /**
     * SchemaImpl root tag
     */
    public static final String ENDPOINT_ROOT_TAG = "endpoint";
    
    public static final String ENDPOINT_REFERENCE_NAME = "EndpointReference";        
    
    public static final QName ENDPOINT_REFERENCE_QNAME = new QName(WSADDRESSING_NAMESPACE,ENDPOINT_REFERENCE_NAME);


    //public static final String NAMESPACE_URI = "http://www.w3.org/2005/08/addressing";

    //public static final String PREFIX = "wsa";

    public static final QName REPLY_TO_QNAME = new QName(WSADDRESSING_NAMESPACE, "ReplyTo", WSADDRESSING_PREFIX);

    public static final QName ADDRESS_QNAME = new QName(WSADDRESSING_NAMESPACE, "Address", WSADDRESSING_PREFIX);

    public static final QName SERVICE_NAME_QNAME = new QName(WSADDRESSING_NAMESPACE, "ServiceName",
    		WSADDRESSING_PREFIX);

    public static final QName FROM_QNAME = new QName(WSADDRESSING_NAMESPACE, "From", WSADDRESSING_PREFIX);

    public static final QName TO_QNAME = new QName(WSADDRESSING_NAMESPACE, "To", WSADDRESSING_PREFIX);

    public static final QName FAULT_TO_QNAME = new QName(WSADDRESSING_NAMESPACE, "FaultTo", WSADDRESSING_PREFIX);

    public static final QName ACTION_QNAME = new QName(WSADDRESSING_NAMESPACE, "Action", WSADDRESSING_PREFIX);

}
