/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.addressing.definition.impl;

import java.io.File;
import java.io.StringWriter;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.lang.NotImplementedException;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.xml.Transformers;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingWriter;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.AbstractSchemaElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSAddressingWriterImpl extends WSAddressingJAXBContext implements WSAddressingWriter {

    public WSAddressingWriterImpl() throws WSAddressingException {
        try {
            WSAddressingJAXBContext.createDefaultContext();
        } catch (final WSAddressingException e) {
            throw new WSAddressingException(e);
        }
    }

    public WSAddressingWriterImpl(List<Class> addedObjectFactories) throws WSAddressingException {
        try {
            WSAddressingJAXBContext.createContextWithOtherObjectFactories(addedObjectFactories);
        } catch (final WSAddressingException e) {
            throw new WSAddressingException(e);
        }
    }

    @SuppressWarnings("unchecked")
    private static Document convertEndpointReferenceType2DOMElement(final QName tagName,
            final com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType def)
            throws WSAddressingException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

            // TODO : Check if it is a Thread safe method
            @SuppressWarnings("rawtypes")
            final JAXBElement element = new JAXBElement(tagName, def.getClass(), def);

            WSAddressingWriterImpl.getJaxbContext().createMarshaller().marshal(element, doc);
        } catch (final JAXBException ex) {
            throw new WSAddressingException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
        } catch (final ParserConfigurationException ex) {
            throw new WSAddressingException(
                    "Failed to build XML binding from SchemaImpl descriptor Java classes", ex);

        }
        return doc;
    }

    @SuppressWarnings("unchecked")
    private static String convertEndpointReferenceType2String(
            final com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType def)
            throws WSAddressingException {

        try {
            final StringWriter stringWriter = new StringWriter();
            // TODO : Check if it is a Thread safe method

            @SuppressWarnings("rawtypes")
            final JAXBElement element = new JAXBElement(new QName(Constants.WSADDRESSING_NAMESPACE,
                    Constants.ENDPOINT_ROOT_TAG), def.getClass(), def);

            WSAddressingWriterImpl.getJaxbContext().createMarshaller()
                    .marshal(element, stringWriter);

            return stringWriter.toString();
        } catch (final JAXBException e) {
            throw new WSAddressingException(
                    "Failed to build XML binding from Agreement descriptor Java classes", e);
        }
    }

    public Document getDocument(final EndpointReferenceType def) throws WSAddressingException {
        Document doc = null;
        if ((def != null) && (def instanceof EndpointReferenceType)) {
            doc = WSAddressingWriterImpl
                    .convertEndpointReferenceType2DOMElement(
                            def.getTagQName(),
                            (com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl) def)
                                    .getModel());
            if (def.getDocumentBaseURI() != null) {
                doc.setDocumentURI(def.getDocumentBaseURI().getPath());
            }
        }
        return doc;
    }

    public boolean getFeature(final String name) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public void setFeature(final String name, final boolean value) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public String writeEndpointReferenceType(final EndpointReferenceType def)
            throws WSAddressingException {
        String res = null;
        if ((def != null) && (def instanceof EndpointReferenceType)) {
            res = WSAddressingWriterImpl
                    .convertEndpointReferenceType2String((com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl) def)
                            .getModel());

        }
        return res;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingWriter
     * #writeEndpointReferenceType
     * (com.ebmwebsourcing.wsstar.addressing.definition
     * .api.EndpointReferenceType, java.io.File)
     */
    public void writeEndpointReferenceType(EndpointReferenceType edpRef, File file)
            throws WSAddressingException {
        Document edpRefAsDoc = this.getDocument(edpRef);
        this.flushToFile(edpRefAsDoc, file);
    }

    /**
     * write a DOM document to a file
     * 
     * @param doc
     *            the DOM document to write on the file system
     * @param file
     *            the file which the DOM document must be write in
     * @throws WSNotificationException
     */
    private void flushToFile(Document doc, File file) throws WSAddressingException {

        // Prepare the DOM document for writing
        Source source = new DOMSource(doc);

        // Prepare the output file
        Result result = new StreamResult(file);

        // Write the DOM document to the file
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(source, result);
        } catch (TransformerException e) {
            throw new WSAddressingException("Problem occurs during \"persistency\" process", e);
        } finally {
            if(transformer != null) {
                Transformers.releaseTransformer(transformer);
            }
        }

    }
}
