/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.agreement.service.impl;

import com.ebmwebsourcing.agreement.definition.WSAgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.AgreementTemplate;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.wsstar.agreement.service.api.AgreementService;
import java.util.UUID;
import org.w3c.dom.Document;

public class AgreementServiceImpl
implements AgreementService {
    private WSAgreementFactory factory = WSAgreementFactory.newInstance();

    @Override
    public Agreement createClientAgreement() throws WSAgreementException {
        return this.factory.newAgreement();
    }

    @Override
    public AgreementTemplate createProviderAgreementTemplate() throws WSAgreementException {
        AgreementTemplate template = this.factory.newAgreementTemplate();
        template.setTemplateId(UUID.randomUUID().toString());
        return template;
    }

    @Override
    public Agreement createClientAgreementFromProviderTemplate(AgreementTemplate template) throws WSAgreementException {
        Agreement ag = this.factory.newAgreement();
        ag.setName(template.getName());
        ag.setContext(template.getContext());
        ag.getContext().setTemplateId(template.getTemplateId());
        ag.getContext().setTemplateName(template.getName());
        ag.setServiceDescription(template.getServiceDescription());
        ag.setServiceReference(template.getServiceReference());
        ag.setServiceProperties(template.getServiceProperties());
        ag.setGuaranteeTerms(template.getGuaranteeTerms());
        Document doc = this.factory.newWSAgreementWriter().getDocument(ag);
        ag = this.factory.newWSAgreementReader().read(doc);
        return ag;
    }

    @Override
    public Agreement acceptClientAgreement(Agreement required, AgreementTemplate offer) {
        ((AgreementLifeCycle)required).setState(AgreementLifeCycle.State.PENDING);
        Agreement agreementMatched = this.match(required, offer);
        if (agreementMatched != null) {
            ((AgreementLifeCycle)required).setState(AgreementLifeCycle.State.OBSERVE);
        } else {
            ((AgreementLifeCycle)required).setState(AgreementLifeCycle.State.REJECTE);
        }
        return required;
    }

    @Override
    public Agreement match(Agreement required, AgreementTemplate offer) {
        return null;
    }
}

