/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.topics.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;

public class TopicNamespaceTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType> implements TopicNamespaceType {

	private static final long serialVersionUID = 1L;

	public TopicNamespaceTypeImpl(final com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType model, final AbstractSchemaElementImpl<?> parent) {
		super(model, parent);
	}

	public void addTopic(final TopicType value) {
		final com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.Topic newTopic = new com.ebmwebsourcing.wsstar.notification.definition.topics.ObjectFactory().createTopicNamespaceTypeTopic();
		newTopic.setName(value.getName());
		final List<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType> list = ((com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType) ((AbstractSchemaElementImpl<?>) value).getModel()).getTopic();
		for (final com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType topic : list) {
			newTopic.getTopic().add(topic);
		}
		this.model.getTopic().add(newTopic);
	}

	public String getName() {
		return this.model.getName();
	}

	public String getTargetNamespace() {
		return this.model.getTargetNamespace();
	}

	public List<TopicType> getTopics() {
		final List<TopicType> result = new ArrayList<TopicType>();
		final List<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.Topic> topicListOfModel = this.model.getTopic();
		for (final com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.Topic item : topicListOfModel) {
			result.add(new TopicTypeImpl(item, this)); // "This" or "null" : what is the question !
		}
		return result;
	}

	public void setName(final String value) {
		this.model.setName(value);
	}

	public void setTargetNamespace(final String value) {
		this.model.setTargetNamespace(value);
	}

	public void addOtherElements(final Element arg0) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

}
