/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.topics.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.notification.definition.topics.WstopConstants;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;

public class TopicTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType> implements TopicType {
	private static final long serialVersionUID = 1L;
	private List<String> registrationIds = null;
	private List<String> subscriptionIds = null;
	private QueryExpressionType messagePattern = null;

	public TopicTypeImpl(final com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType model, final AbstractSchemaElementImpl<?> parent) {
		super(model, parent);
		this.registrationIds = new ArrayList<String>();
		this.subscriptionIds = new ArrayList<String>();
		this.messagePattern = new QueryExpressionTypeImpl(this.model.getMessagePattern(), this);
	}

	public void addTopicChild(final TopicType value) {
		this.model.getTopic().add((com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType) ((AbstractSchemaElementImpl<?>) value).getModel());
	}

	public List<TopicType> getChildren() {
		final List<TopicType> result = new ArrayList<TopicType>();
		final List<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType> topicListOfModel = this.model.getTopic();
		for (final com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType item : topicListOfModel) {
			result.add(new TopicTypeImpl(item, this)); // "This" or "null" : what is the question !
		}
		return result;
	}

	public String getName() {
		return this.model.getName();
	}

	public void setName(final String value) {
		this.model.setName(value);
	}

	public List<String> getRegistrationIds() {
		return this.registrationIds;
	}

	public List<String> getSubscriptionIds() {
		return this.subscriptionIds;
	}

	public List<QName> getMessageTypes() {
		return this.model.getMessageTypes();
	}

	public QueryExpressionType getMessagePattern() {
		return this.messagePattern;
	}

	public Boolean isSupported() {
		Boolean res = null;
		final String value = this.model.getOtherAttributes().get(WstopConstants.SUPPORTED_QNAME_ATTR);
		if (value != null) {
			res = Boolean.valueOf(value);
		}
		return res;
	}

	public void setSupported(final Boolean support) {
		if (support != null) {
			if (support == true) {
				this.model.getOtherAttributes().put(WstopConstants.SUPPORTED_QNAME_ATTR, support.toString());
			} else {
				this.model.getOtherAttributes().remove(WstopConstants.SUPPORTED_QNAME_ATTR);
			}
		}
	}

	public void addOtherElements(final Element arg0) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

}
