/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.utils;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Element;

/**
 * set of static methods to convert returned jaxb2 types to
 * "more user friendly" encapsulation Java types
 * 
 * @author Thierry Déjean - eBM WebSourcing
 *
 */
public class JaxbTypeConvertor {

	/**
	 * convert default list of Java Object return by the JAXB layer
	 * to a list of org.w3c.dom.Element. 
	 *  	 
	 * @param list
	 * @return a java List of Element
	 */
	public static List<Element> JaxbObjectListToElementList(List<Object> list){
		List<Element> result = new ArrayList<Element>();
		for (Object object : list) {
			result.add((Element)object);
		}		
		return result;		
	}
	

}
