/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.inout;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
//import com.ebmwebsourcing.wsstar.addressing.addressing4notification.impl.inout.WSAddressing4NotifReaderImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.WsnbConstants;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.NotifyImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.QueryExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.SubscribeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.SubscribeResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnsubscribeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnsubscribeResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.WsnbrConstants;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.DestroyRegistrationImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.DestroyRegistrationResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.RegisterPublisherImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.RegisterPublisherResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.Topic;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicSetType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.impl.TopicNamespaceTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.topics.impl.TopicSetTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.topics.impl.TopicTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationJAXBContext;


/**
 * This class implements the {@link WSNotificationReader} java interface
 * 
 * @author Thierry Déjean - eBM Websourcing
 */
public class WSNotificationReaderImpl implements WSNotificationReader {

	private static Logger log = Logger.getLogger(WSNotificationReaderImpl.class.getName());

	private WSNotificationJAXBContext notifJaxbContext = null;
	
	/**
	 * Default constructor
	 * @throws WSNotificationException
	 */
	public WSNotificationReaderImpl() throws WSNotificationException {
		try {
			notifJaxbContext = new WSNotificationJAXBContext();
		} catch (Exception e) {
			throw new WSNotificationException(e);
		}
	}

	/**
	 * @return the jaxbContext
	 */
	public JAXBContext getJaxbContext() {
		return this.getJaxbContext();
	}

	// ============================== Added by tdejean ============================================

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readRegisterPublisher(org.w3c.dom.Document)
	 */
	public RegisterPublisher readRegisterPublisher(final Document doc) throws WSNotificationException {
		RegisterPublisher result = null;
		
		try {
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher> schemaBinding = 
            	this.unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher.class);
            result = new RegisterPublisherImpl(schemaBinding.getValue(),null);
			 */

			// just convert:
			// TODO : replace JDOM and DOM with StaxSource   
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document docAsJDom = builder.build(doc);

			List<List<Namespace>> additionalNSPerExp = new ArrayList<List<Namespace>>(); 
			List<?> topExprNodes = docAsJDom.getRootElement().getChildren(WsnbrConstants.TOPIC_QNAME.getLocalPart(),
					Namespace.getNamespace(WsnbrConstants.TOPIC_QNAME.getNamespaceURI()));

			for (Object topExprNode : topExprNodes) {
				additionalNSPerExp.add(((Element)topExprNode).getAdditionalNamespaces());				
			}

			com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher) unmarshaller.unmarshal(doc);
			result = new RegisterPublisherImpl(JaxbTypeObj,null);

			List<TopicExpressionType> listOfTopicExpr = result.getTopic();
			for (TopicExpressionType topExprItem : listOfTopicExpr) {
				for (Namespace nsItem : additionalNSPerExp.get(listOfTopicExpr.indexOf(topExprItem))) {
					topExprItem.addTopicNameSpace(nsItem.getPrefix(), nsItem.getURI());
				}				
			}


		} catch (JAXBException e) {
			throw new WSNotificationException(e);
		} catch (SchemaException e) {
			throw new WSNotificationException(e);
		}		
		return result;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readRegisterPublisherResponse(org.w3c.dom.Document)
	 */
	public RegisterPublisherResponse readRegisterPublisherResponse(Document doc)
	throws WSNotificationException {
		RegisterPublisherResponse result = null;
		try {	
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse> schemaBinding =
            	unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse.class);
            result = new RegisterPublisherResponseImpl(schemaBinding.getValue(),null);
			/* 		
			com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse) unmarshaller.unmarshal(doc);
			result = new RegisterPublisherResponseImpl(JaxbTypeObj,null);			
			*/

		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}		
		return result;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readDestroyRegistration(org.w3c.dom.Document)
	 */
	public DestroyRegistration readDestroyRegistration(Document doc)
	throws WSNotificationException {
		DestroyRegistration result = null;
		try {			
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration> schemaBinding =
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration.class);
            result = new DestroyRegistrationImpl(schemaBinding.getValue(),null);
			 */
			com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration) unmarshaller.unmarshal(doc);
			result = new DestroyRegistrationImpl(JaxbTypeObj,null);

		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}		
		return result;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readDestroyRegistrationResponse(org.w3c.dom.Document)
	 */
	public DestroyRegistrationResponse readDestroyRegistrationResponse(Document doc)
	throws WSNotificationException {
		DestroyRegistrationResponse result = null;
		try {			
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse> schemaBinding =
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse.class);
            result = new DestroyRegistrationResponseImpl(schemaBinding.getValue(),null);
			 */
			com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse) unmarshaller.unmarshal(doc);
			result = new DestroyRegistrationResponseImpl(JaxbTypeObj,null);			
		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}		
		return result;	
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readSubscribe(org.w3c.dom.Document)
	 */
	public Subscribe readSubscribe(Document doc) throws WSNotificationException {
		Subscribe result = null;
		try {			
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe> schemaBinding = 
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe.class);
            result = new SubscribeImpl(schemaBinding.getValue(),null);
			 */

			// just convert:
			// TODO : replace JDOM and DOM with StaxSource   
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document docAsJDom = builder.build(doc);			

			//For each NotificationMessage get Topic Node and "extract" topicNS
			Element topicExpressionNode = docAsJDom.getRootElement().getChild(WsnbConstants.FILTER_QNAME.getLocalPart(),
					Namespace.getNamespace(WsnbConstants.FILTER_QNAME.getNamespaceURI())).getChild(WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart(),
							Namespace.getNamespace(WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI()));
			List<Namespace> additionalTopicsNS = topicExpressionNode.getAdditionalNamespaces();

			// Process unmarshalling operation :
			com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe) unmarshaller.unmarshal(doc);
			result = new SubscribeImpl(JaxbTypeObj,null);

			for (Namespace nsItem : additionalTopicsNS) {
				result.getFilter().getTopicExpression().addTopicNameSpace(((Namespace)nsItem).getPrefix(), ((Namespace)nsItem).getURI());            	
			}			

		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}				
		return result;
	}	

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readSubscribeResponse(org.w3c.dom.Document)
	 */
	public SubscribeResponse readSubscribeResponse(Document doc)
	throws WSNotificationException {
		SubscribeResponse result = null;
		try {			
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse> schemaBinding =
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse.class);
            result = new SubscribeResponseImpl(schemaBinding.getValue(),null);
			 */
			com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse) unmarshaller.unmarshal(doc);
			result = new SubscribeResponseImpl(JaxbTypeObj,null);
		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}				
		return result;
	}
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readUnsubscribe(org.w3c.dom.Document)
	 */
	public Unsubscribe readUnsubscribe(Document doc)
	throws WSNotificationException {
		Unsubscribe result = null;
		try {
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe> schemaBinding =
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe.class);
            result = new UnsubscribeImpl(schemaBinding.getValue(),null);
			 */
			com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe) unmarshaller.unmarshal(doc);
			result = new UnsubscribeImpl(JaxbTypeObj,null);
		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}
		return result;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readUnsubscribeResponse(org.w3c.dom.Document)
	 */
	public UnsubscribeResponse readUnsubscribeResponse(Document doc)
	throws WSNotificationException {
		UnsubscribeResponse result = null;
		try {			
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();
			
			// TODO : Check if it is a Thread safe method
			/*
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse> schemaBinding = 
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse.class);
            result = new UnsubscribeResponseImpl(schemaBinding.getValue(),null);
			 */
			com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse JaxbTypeObj = 
				(com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse) unmarshaller.unmarshal(doc);
			result = new UnsubscribeResponseImpl(JaxbTypeObj,null);
		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}
		return result;

	}
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readNotify(org.w3c.dom.Document)
	 */
	public Notify readNotify(Document doc) throws WSNotificationException {
		Notify result = null;
		try {
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Notify> schemaBinding = 
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.Notify.class);
            result = new NotifyImpl(schemaBinding.getValue(),null);
			 */

			// just convert:
			// TODO : replace JDOM and DOM with StaxSource   
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document docAsJDom = builder.build(doc);

			List<List<Namespace>> additionalTopicNSPerMsg = new ArrayList<List<Namespace>>();

			//For each NotificationMessage get Topic Node and "extract" topicNS
			List<?> notifMsgNodes = docAsJDom.getRootElement().getChildren(WsnbConstants.NOTIFICATION_MSG_QNAME.getLocalPart(),
					Namespace.getNamespace(WsnbConstants.NOTIFICATION_MSG_QNAME.getNamespaceURI()));

			Element currentTopicNode = null;
			for (Object msgNode : notifMsgNodes) {
				currentTopicNode = ((Element)msgNode).getChild(WsnbConstants.TOPIC_QNAME.getLocalPart(),
						Namespace.getNamespace(WsnbConstants.TOPIC_QNAME.getNamespaceURI()));	
				additionalTopicNSPerMsg.add(currentTopicNode.getAdditionalNamespaces());
			}

			// Process unmarshalling operation :
			com.ebmwebsourcing.wsstar.notification.definition.base.Notify JaxbTypeObj = 
				(com.ebmwebsourcing.wsstar.notification.definition.base.Notify) unmarshaller.unmarshal(doc);
			result = new NotifyImpl(JaxbTypeObj,null);

			// set topicNS In corresponding TopicExpression model object
			List<NotificationMessageHolderType> notifMessages = result.getNotificationMessage(); 
			for (NotificationMessageHolderType notifMsgItem : notifMessages) {
				List<Namespace> topicNSToAdd = additionalTopicNSPerMsg.get(notifMessages.indexOf(notifMsgItem));
				for (Namespace currentNs : topicNSToAdd) {
					notifMsgItem.getTopic().addTopicNameSpace(currentNs.getPrefix(),currentNs.getURI());
				}
			}			

		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		} catch (SchemaException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}                    		
		return result;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readTopicExpressionType(org.w3c.dom.Document)
	 */
	public TopicExpressionType readTopicExpressionType(Document doc)
	throws WSNotificationException {
		TopicExpressionType result = null;
		try {

			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();
			
			// just convert:
			// TODO : replace JDOM and DOM with StaxSource   
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document docAsJDom = builder.build(doc);

			List<?> additionalNS = docAsJDom.getRootElement().getAdditionalNamespaces();

			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType.class);
			result = new TopicExpressionTypeImpl(schemaBinding.getValue(),null);

			for (Object item : additionalNS) {
				result.addTopicNameSpace(((Namespace)item).getPrefix(), ((Namespace)item).getURI());            	
			}

			/*
           	// TODO : Check if it is a Thread safe method					
			com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType JaxbTypeObj = 
				(com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType) WSNotificationReaderImpl.unmarshaller.unmarshal(doc);
			result = new TopicExpressionTypeImpl(JaxbTypeObj,null);
			 */

		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		} catch (SchemaException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}                    		

		return result;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readQueryExpressionType(org.w3c.dom.Document)
	 */
	public QueryExpressionType readQueryExpressionType(Document doc)
	throws WSNotificationException {
		QueryExpressionType result = null;
		try {
		
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();
			
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType.class);
			result = new QueryExpressionTypeImpl(schemaBinding.getValue(),null);
		
		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		}                    		
		return result;
	}
		
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readTopicType(org.w3c.dom.Document)
	 */
	public TopicType readTopicType(Document doc) throws WSNotificationException {
		TopicType result = null;
		try {
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType.class);
			result = new TopicTypeImpl(schemaBinding.getValue(),null);
			/*
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.Topic> schemaBinding = 
            	WSNotificationReaderImpl.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.Topic.class);
            result = new TopicTypeImpl(schemaBinding.getValue(),null);
			 */
			/*					
			com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType JaxbTypeObj = 
				(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType) WSNotificationReaderImpl.unmarshaller.unmarshal(doc);
			result = new TopicSetTypeImpl(JaxbTypeObj,null);
			 */

		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		} /*catch (SchemaException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } */                   		
		return result;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readTopicNamespaceType(org.w3c.dom.Document)
	 */
	public TopicNamespaceType readTopicNamespaceType(Document doc)
	throws WSNotificationException {	
		TopicNamespaceType result = null;
		try {
			// TODO : Check if it is a Thread safe method

			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();
			
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.class);
			result = new TopicNamespaceTypeImpl(schemaBinding.getValue(),null);

			/*
				com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType JaxbTypeObj = 
					(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType) WSNotificationReaderImpl.unmarshaller.unmarshal(doc);
				result = new TopicNamespaceTypeImpl(JaxbTypeObj,null);				
			 */
		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		} /*catch (SchemaException e) {
	            // TODO Auto-generated catch block
	            e.printStackTrace();
	        } */                   		
		return result;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.definition.api.WSNotificationReader#readTopicSetType(org.w3c.dom.Document)
	 */
	public TopicSetType readTopicSetType(Document doc)
	throws WSNotificationException {
		TopicSetType result = null;
		try {
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();
			
			// TODO : Check if it is a Thread safe method

			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType.class);
			result = new TopicSetTypeImpl(schemaBinding.getValue(),null);

			/*
			com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType JaxbTypeObj = 
				(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType) WSNotificationReaderImpl.unmarshaller.unmarshal(doc);
			result = new TopicNamespaceTypeImpl(JaxbTypeObj,null);				
			 */
		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		} /*catch (SchemaException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } */                   		
		return result;
	}

	// ==================================================================================		

}
