/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.inout;

import java.io.File;

import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicSetType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

/**
 * This interface describes a collection of methods that enable conversion of a
 * "WS-{Base/Brokered}Notification java type" object into a {@link Document} object.
 * This conversion uses JAXB "unmarshalling" mechanism
 * 
 * @author Thierry Déjean - eBM WebSourcing
 */
public interface WSNotificationWriter {

    // ===================== Added by tdejean =============================
    
    /**
     * marchall a {@link Notify} object.
     * 
     * @param notifyObj {@link Notify} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link Notify} Java type 
     * @throws WSNotificationException
     */
    public Document writeNotify(Notify notifyObj) throws WSNotificationException;
    
    /**
     * marchall a {@link RegisterPublisher} object.
     * 
     * @param regPubObj {@link RegisterPublisher} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link RegisterPublisher} Java type
     * @throws WSNotificationException
     */
    public Document writeRegisterPublisher(RegisterPublisher regPubObj) throws WSNotificationException;
    
    /**
     * marchall a {@link RegisterPublisherResponse} object.
     * 
     * @param regPubRespObj {@link RegisterPublisherResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link RegisterPublisherResponse} Java type 
     * @throws WSNotificationException
     */
    public Document writeRegisterPublisherResponse(RegisterPublisherResponse regPubRespObj) throws WSNotificationException;

    /**
     * marchall a {@link DestroyRegistration} object.
     * 
     * @param destRegObj {@link DestroyRegistration} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link DestroyRegistration} Java type
     * @throws WSNotificationException
     */
    public Document writeDestroyRegistration(DestroyRegistration destRegObj) throws WSNotificationException;
    
    /**
     * marchall a {@link DestroyRegistrationResponse} object.
     * 
     * @param destRegRespObj {@link DestroyRegistrationResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link DestroyRegistrationResponse} Java type 
     * @throws WSNotificationException
     */    
    public Document writeDestroyRegistrationResponse(DestroyRegistrationResponse destRegRespObj) throws WSNotificationException;
    
    /**
     * marshall a {@link Subscribe} object
     * 
     * @param subsObj {@link SubscribeResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link Subscribe} Java type
     * @throws WSNotificationException
     */
    public Document writeSubscribe(Subscribe subsObj) throws WSNotificationException;
    
    /**
     * marshall a {@link SubscribeResponse} object
     * 
     * @param subsRespObj {@link SubscribeResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link SubscribeResponse} Java type 
     * @throws WSNotificationException
     */
    public Document writeSubscribeResponse(SubscribeResponse subsRespObj) throws WSNotificationException;
    
    /**
     * marshall an {@link Unsubscribe} object
     * 
     * @param unsubsObj {@link unsubscribe} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link Unsubscribe} Java type
     * @throws WSNotificationException
     */
    public Document writeUnsubscribe(Unsubscribe unsubsObj) throws WSNotificationException;
    
    /**
     * marshall an {@link UnsubscribeResponse} object
     * 
     * @param unsubsRespObj {@link unsubscribeResponse} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link UnsubscribeResponse} Java type
     * @throws WSNotificationException
     */
    public Document writeUnsubscribeResponse(UnsubscribeResponse unsubsRespObj) throws WSNotificationException;
    
    /**
     * marshall a {@link SubscriptionManagerRP} into a file (used to persist the java object) 
     * 
     * @param subscription the {@link SubscriptionManagerRP} java object to persist
     * @param file {@link File} object used to persist {@link SubscriptionManagerRP} Object
     * @throws WSNotificationException
     */
    public void writeSubscriptionToFile(SubscriptionManagerRP subscription, File file) throws WSNotificationException;
    
    
    /**
     * marshall a {@link TopicExpressionType} object
     * 
     * @param topicExpression {@link TopicExpressionType} Java object to marshall
     * @return {@linkorg.w3c.dom.Document} representation of the {@link TopicExpressionType} Java type
     * @throws WSNotificationException
     */
    public Document writeTopicExpressionType(TopicExpressionType topicExpression) throws WSNotificationException;
	
    /**
     * marshall a {@link QueryExpressionType} object
     * 
     * @param topicExpression {@link QueryExpressionType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link TopicExpressionType} Java type
     * @throws WSNotificationException
     */
    public Document writeQueryExpressionType(QueryExpressionType queryExpression) throws WSNotificationException;
	    
    /**
     * marshall a {@link TopicType} object
     * 
     * @param topic {@link TopicType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link TopicType} Java type
     * @throws WSNotificationException
     */
    public Document writeTopicType(TopicType topic) throws WSNotificationException;
	
    /**
     * marshall a {@link TopicNamespaceType} object
     * 
     * @param namespace {@link TopicNamespaceType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link TopicNamespaceType} Java type
     * @throws WSNotificationException
     */
    public Document writeTopicNamespaceType(TopicNamespaceType namespace) throws WSNotificationException;
    
    /**
     * marshall a {@link TopicSetType} object
     * 
     * @param namespace {@link TopicSetType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link TopicSetType} Java type
     * @throws WSNotificationException
     */
    public Document writeTopicSetType(TopicSetType topicSet) throws WSNotificationException;
	
    // ======================================================================
}