/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.basenotification;

import javax.xml.namespace.QName;

/**
 * Constants of WS-BaseNotification
 * 
 * @author Thierry Déjean - eBM WebSourcing
 */
public class WsnbConstants {

	// ============== WS-BaseNotification constants ===========================
	public static final String WS_BASE_NOTIFICATION_NAMESPACE_URI = "http://docs.oasis-open.org/wsn/b-2";

	public static final String WS_BASE_NOTIFICATION_PREFIX = "wsnt";

	public static final QName CONSUMER_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "ConsumerReference", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName CREATION_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "CreationTime", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName CURRENT_TIME_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "CurrentTime", WS_BASE_NOTIFICATION_PREFIX);

	public static final String DIALECT = "Dialect";

	public static final QName FILTER_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "Filter", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName FIXED_SET_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "FixedTopicSet", WS_BASE_NOTIFICATION_PREFIX);

	public static final String GET_CURRENT_MESSAGE_NAME = "GetCurrentMessage";
	public static final QName GET_CURRENT_MESSAGE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, GET_CURRENT_MESSAGE_NAME, WS_BASE_NOTIFICATION_PREFIX);

	public static final QName GET_CURRENT_MESSAGE_RESPONSE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "GetCurrentMessageResponse", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName INIT_TERMINATION_TIME_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "TerminationTime", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName INVALID_FILTER_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "InvalidFilterFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName INVALID_MESSAGE_CONTENT_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "InvalidMessageContentExpressionFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName INVALID_PRODUCER_PROPERTIES_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "InvalidProducerPropertiesExpressionFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName INVALID_TOPIC_EXPRESSION_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "InvalidTopicExpressionFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName MESSAGE_CONTENT_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "MessageContent", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName MESSAGE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "Message", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName MULTIPLE_TOPICS_SPECIFIED_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "MultipleTopicsSpecifiedFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName NO_CURRENT_MESSAGE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "NoCurrentMessageOnTopicFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName NOTIFICATION_MSG_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "NotificationMessage", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName NOTIFY_NOT_SUPPORTED_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "NotifyMessageNotSupportedFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final String NOTIFY_NAME = "Notify";
	public static final QName NOTIFY_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, NOTIFY_NAME, WS_BASE_NOTIFICATION_PREFIX);

	public static final QName NOTIFY_RESPONSE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "NotifyResponse", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName PAUSE_FAILED_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "PauseFailedFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final String PAUSE_SUBSCRIPTION_NAME = "PauseSubscription";
	public static final QName PAUSE_SUBSCRIPTION_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, PAUSE_SUBSCRIPTION_NAME, WS_BASE_NOTIFICATION_PREFIX);

	public static final QName PAUSE_SUBSCRIPTION_RESPONSE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "PauseSubscriptionResponse", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName POLICY_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "SubscriptionPolicy", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName PRODUCER_PROPERTIES_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "ProducerProperties", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName PRODUCER_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "ProducerReference", WS_BASE_NOTIFICATION_PREFIX);

	public static final String RENEW_NAME = "Renew";
	public static final QName RENEW_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, RENEW_NAME, WS_BASE_NOTIFICATION_PREFIX);

	public static final QName RENEW_RESPONSE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "RenewResponse", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName RESUME_FAILED_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "ResumeFailedFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final String RESUME_SUSBCRIPTION_NAME = "ResumeSubscription";
	public static final QName RESUME_SUSBCRIPTION_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, RESUME_SUSBCRIPTION_NAME, WS_BASE_NOTIFICATION_PREFIX);

	public static final QName RESUME_SUBSCRIPTION_RESPONSE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "ResumeSubscriptionResponse", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName SUBSCRIBE_FAILED_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "SubscribeCreationFailedFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final String SUBSCRIBE_NAME = "Subscribe";
	public static final QName SUBSCRIBE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, SUBSCRIBE_NAME, WS_BASE_NOTIFICATION_PREFIX);

	public static final QName SUBSCRIBE_RESPONSE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "SubscribeResponse", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName SUBSCRIPTION_EPR_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "SubscriptionReference", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName SUBSCRIPTION_MGR_RP_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "SubscriptionManagerRP", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName TERMINATION_TIME_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "TerminationTime", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName TOPIC_DIALECT_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "TopicExpressionDialect", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName TOPIC_DIALECT_UNKNOWN_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "TopicExpressionDialectUnknownFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName TOPIC_EXPRESSION_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "TopicExpression", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName TOPIC_NOT_SUPPORTED_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "TopicNotSupportedFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName TOPIC_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "Topic", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName UNABLE_TO_CREATE_PULL_POINT_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "UnableToCreatePullPointFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName UNABLE_TO_GET_MESSAGES_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "UnableToGetMessagesFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName UNACCEPTABLE_TERMINATION_TIME_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "UnacceptableInitialTerminationTimeFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName UNRECOGNIZED_POLICY_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "UnrecognizedPolicyRequestFault", WS_BASE_NOTIFICATION_PREFIX);

	public static final String UNSUBSCRIBE_NAME = "Unsubscribe";
	public static final QName UNSUBSCRIBE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, UNSUBSCRIBE_NAME, WS_BASE_NOTIFICATION_PREFIX);

	public static final QName UNSUBSCRIBE_RESPONSE_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "UnsubscribeResponse", WS_BASE_NOTIFICATION_PREFIX);

	public static final QName UNSUPPORTED_POLICY_QNAME = new QName(WS_BASE_NOTIFICATION_NAMESPACE_URI, "UnsupportedPolicyRequestFault", WS_BASE_NOTIFICATION_PREFIX);
}
