/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.WsnbConstants;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class SubscribeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe> implements Subscribe {
	private static final long serialVersionUID = 1L;
	private EndpointReferenceType eprConsumer = null;

	public SubscribeImpl(final com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe model, final AbstractSchemaElementImpl parent) throws WSNotificationException {
		super(model, parent);
		try {
			if (model.getConsumerReference() != null) {
				this.eprConsumer = new EndpointReferenceTypeImpl(model.getConsumerReference(), this);
			}
		} catch (final WSAddressingException e) {
			throw new WSNotificationException(e);
		}

	}

	public void addOtherElements(final Element elmt) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

	public EndpointReferenceType getConsumerReference() throws WSNotificationException {
		return this.eprConsumer;
	}

	public FilterType getFilter() {
		final com.ebmwebsourcing.wsstar.notification.definition.base.FilterType objFromModel = this.model.getFilter();
		return objFromModel != null ? new FilterTypeImpl(objFromModel, null) : null;
	}

	public Date getInitialTerminationTime() {
		Date initTime = null;
		final JAXBElement<String> jaxbEltInitTermTime = this.model.getInitialTerminationTime();
		if (jaxbEltInitTermTime != null) {
			final String initTermTime = jaxbEltInitTermTime.getValue();
			XMLGregorianCalendar xmlCalendar;
			try {
				xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(initTermTime);
				initTime = xmlCalendar.toGregorianCalendar().getTime();
			} catch (final DatatypeConfigurationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return initTime;
	}

	public void setConsumerReference(final EndpointReferenceType ref) {
		((AbstractSchemaElementImpl) ref).setParent(this);
		this.eprConsumer = ref;
		this.model.setConsumerReference((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl<?>) ref).getModel());
	}

	public void setFilter(final FilterType filter) {
		((AbstractSchemaElementImpl) filter).setParent(this);
		this.model.setFilter((com.ebmwebsourcing.wsstar.notification.definition.base.FilterType) ((AbstractSchemaElementImpl<?>) filter).getModel());
	}

	public void setInitialTerminationTime(final Date value) throws WSNotificationException {
		final GregorianCalendar gCalendar = new GregorianCalendar();
		gCalendar.setTime(value);
		XMLGregorianCalendar xmlCalendar;

		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
			// this.model.setInitialTerminationTime(xmlCalendar.toXMLFormat());
			this.model.setInitialTerminationTime(WSNotificationFactory.getInstance().createStringJaxbElt(WsnbConstants.INIT_TERMINATION_TIME_QNAME, xmlCalendar.toXMLFormat()));
		} catch (final DatatypeConfigurationException e) {
			throw new WSNotificationException(e);
		}
	}

	public SubscriptionPolicyType getSubscriptionPolicy() {

		SubscriptionPolicyType result = null;

		final com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe.SubscriptionPolicy extractedSubscription = this.model.getSubscriptionPolicy();

		if (extractedSubscription != null) {
			final com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType newModel = new com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType();

			for (final Object item : extractedSubscription.getAny()) {
				newModel.getAny().add(item);
			}

			result = new SubscriptionPolicyTypeImpl(newModel, null);
		}

		return result;
	}

	public void setSubscriptionPolicy(final SubscriptionPolicyType policy) {

		((AbstractSchemaElementImpl) policy).setParent(this);

		final com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType policyModel = ((AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType>) policy).getModel();

		if (policyModel != null) {
			final com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe.SubscriptionPolicy newPolicyObjModel = new com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe.SubscriptionPolicy();

			for (final Object item : policyModel.getAny()) {
				newPolicyObjModel.getAny().add(item);
			}

			this.model.setSubscriptionPolicy(newPolicyObjModel);
		}
	}
}
