/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class PublisherRegistrationRPImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationRP> implements PublisherRegistrationRP {

	private static final long serialVersionUID = 1L;
	private static Logger log = Logger.getLogger(RegisterPublisherImpl.class.getName());
	
	private EndpointReferenceType eprPublisher = null;

	public PublisherRegistrationRPImpl(final com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationRP model, final AbstractSchemaElementImpl<?> parent) throws WSNotificationException {
		super(model, parent);
		
		try {
			if (model.getPublisherReference() != null)
				this.eprPublisher = new EndpointReferenceTypeImpl(model.getPublisherReference(),this);
		} catch (WSAddressingException e) {
			throw new WSNotificationException(e);
		}
		
	}
	
	public Date getCreationTime() {
		XMLGregorianCalendar objFromModel = this.model.getCreationTime();
		return (objFromModel != null) ? objFromModel.toGregorianCalendar().getTime() : null;
	}

	public EndpointReferenceType getPublisherReference() throws WSNotificationException {
		return this.eprPublisher;
	}

	public List<TopicExpressionType> getTopic() throws WSNotificationException {
		List<TopicExpressionType> result = new ArrayList<TopicExpressionType>();
		List<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType> topics = this.model.getTopic();
		if (topics != null)
			for (com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType topic : topics) {
				result.add(new TopicExpressionTypeImpl(topic, null));
			}
		return result;
	}
	
	public void addTopic(TopicExpressionType topic) {
		List<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType> objFromModel = this.model.getTopic();
		if (objFromModel != null)
		objFromModel.add((com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType) ((AbstractSchemaElementImpl<?>) topic).getModel());
	}

	public boolean isDemand() {
		return this.model.isDemand();
	}

	public void setCreationTime(Date value) throws WSNotificationException {

		GregorianCalendar gCalendar = new GregorianCalendar();
		gCalendar.setTime(value);
		XMLGregorianCalendar xmlCalendar;

		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
			this.model.setCreationTime(xmlCalendar);
		} catch (DatatypeConfigurationException e) {
			throw new WSNotificationException(e);
		}
	}

	public void setDemand(boolean value) {
		this.model.setDemand(value);
	}

	public void setPublisherReference(EndpointReferenceType ref) {
		((AbstractSchemaElementImpl)ref).setParent(this);
		this.eprPublisher = ref;
		this.model.setPublisherReference((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl<?>) ref).getModel());
	}
}
