/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.inout;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;

import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.WsnbConstants;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.NotifyImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.QueryExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.SubscribeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.SubscribeResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.SubscriptionManagerRPImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnsubscribeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.UnsubscribeResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.WsnbrConstants;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.DestroyRegistrationImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.DestroyRegistrationResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.PublisherRegistrationRPImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.RegisterPublisherImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl.RegisterPublisherResponseImpl;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicSetType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.topics.impl.TopicNamespaceTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.topics.impl.TopicSetTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.topics.impl.TopicTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationJAXBContext;

/**
 * This class provides a collection of methods that enable conversion of a
 * {@link Document} object into a "WS-{Base/Brokered}Notification java type" object.
 * This conversion uses JAXB "unmarshalling" mechanism
 * 
 * @author Thierry Déjean - eBM WebSourcing
 */
public class WSNotificationReader {

	private static Logger log = Logger.getLogger(WSNotificationReader.class.getName());

	private WSNotificationJAXBContext notifJaxbContext = null;
	
	/**
	 * Default constructor
	 * @throws WSNotificationException
	 */
	private WSNotificationReader () {
		try {
			notifJaxbContext = new WSNotificationJAXBContext();
		} catch (Exception e) {
			log.log(Level.WARNING, "WsNotificationReader initialisation failed !", e);
		}
	}
	
	/**
	 * SingletonHolder is loaded on the first execution of Singleton.getInstance() 
	 * or the first access to SingletonHolder.INSTANCE, not before.
	 */
    private static class WSNotificationReaderHolder {     	
		private final static WSNotificationReader INSTANCE = new WSNotificationReader();
	}
    
    /**
	 * Return an unique - respect to the Singleton design pattern - instance  
	 * of the {@link WSNotificationReader} class.  
	 * 
	 * @return a unique WSNotificationFactory instance. 
	 */
	public static WSNotificationReader getInstance() {
		return WSNotificationReaderHolder.INSTANCE;
	}
	
	/**
	 * Return an unique - respect to the Singleton design pattern - instance  
	 * of the {@link WSNotificationWriter} class.  
	 * 
	 * @return a unique WSNotificationFactory instance. 
	 */
	public static WSNotificationReader getInstance(String[] nsAndPrefixForMarshalling) {
		WSNotificationReader reader =  WSNotificationReaderHolder.INSTANCE;
		reader.notifJaxbContext.addNsAndPrefixMapping(nsAndPrefixForMarshalling);		
		return reader;
	}
		
	
    /**
     * Unmarshall {@link RegisterPublisher} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link RegisterPublisher} Java type 
     * @return a {@link RegisterPublisher} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public RegisterPublisher readRegisterPublisher(final Document doc) throws WSNotificationException{
    	RegisterPublisher result = null;
		
		try {
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher> schemaBinding = 
            	this.unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher.class);
            result = new RegisterPublisherImpl(schemaBinding.getValue(),null);
			 */

			// just convert:
			// TODO : replace JDOM and DOM with StaxSource   
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document docAsJDom = builder.build(doc);

			List<List<Namespace>> additionalNSPerExp = new ArrayList<List<Namespace>>(); 
			List<?> topExprNodes = docAsJDom.getRootElement().getChildren(WsnbrConstants.TOPIC_QNAME.getLocalPart(),
					Namespace.getNamespace(WsnbrConstants.TOPIC_QNAME.getNamespaceURI()));

			for (Object topExprNode : topExprNodes) {
				additionalNSPerExp.add(((Element)topExprNode).getAdditionalNamespaces());				
			}

			com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher) unmarshaller.unmarshal(doc);
			result = new RegisterPublisherImpl(JaxbTypeObj,null);

			List<TopicExpressionType> listOfTopicExpr = result.getTopic();
			for (TopicExpressionType topExprItem : listOfTopicExpr) {
				for (Namespace nsItem : additionalNSPerExp.get(listOfTopicExpr.indexOf(topExprItem))) {
					topExprItem.addTopicNameSpace(nsItem.getPrefix(), nsItem.getURI());
				}				
			}


		} catch (JAXBException e) {
			throw new WSNotificationException(e);
		} catch (SchemaException e) {
			throw new WSNotificationException(e);
		}		
		return result;
    }
    
    /**
     * Unmarshall {@link RegisterPublisherResponse} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link RegisterPublisherResponse} Java type 
     * @return a {@link RegisterPublisherResponse} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public RegisterPublisherResponse readRegisterPublisherResponse(final Document doc) throws WSNotificationException{
    	RegisterPublisherResponse result = null;
		try {	
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse> schemaBinding =
            	unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse.class);
            result = new RegisterPublisherResponseImpl(schemaBinding.getValue(),null);
			/* 		
			com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse) unmarshaller.unmarshal(doc);
			result = new RegisterPublisherResponseImpl(JaxbTypeObj,null);			
			*/

		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}		
		return result;
    }
    
    /**
     * Unmarshall {@link DestroyRegistration} object from a {@link Document} representation fragment object 
     *  
     * @param doc {@link org.w3c.dom.Document} object representation of {@link DestroyRegistration} Java type
     * @return a {@link DestroyRegistration} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public DestroyRegistration readDestroyRegistration(final Document doc) throws WSNotificationException{
    	DestroyRegistration result = null;
		try {			
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration> schemaBinding =
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration.class);
            result = new DestroyRegistrationImpl(schemaBinding.getValue(),null);
			 */
			com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration) unmarshaller.unmarshal(doc);
			result = new DestroyRegistrationImpl(JaxbTypeObj,null);

		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}		
		return result;    }
    
    /**
     * Unmarshall {@link PublisherRegistrationRP} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link PublisherRegistrationRP} Java type 
     * @return a {@link PublisherRegistrationRP} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public PublisherRegistrationRP readPublisherRegistrationRP(final Document doc) throws WSNotificationException{
    	PublisherRegistrationRP result = null;

    	try {	
    		Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

    		// TODO : Check if it is a Thread safe method
    		/*JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher> schemaBinding = 
            	this.unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher.class);
            result = new RegisterPublisherImpl(schemaBinding.getValue(),null);
    		 */

    		// just convert:
    		// TODO : replace JDOM and DOM with StaxSource   
    		DOMBuilder builder = new DOMBuilder();
    		org.jdom.Document docAsJDom = builder.build(doc);

    		List<List<Namespace>> additionalNSPerExp = new ArrayList<List<Namespace>>(); 
    		List<?> topExprNodes = docAsJDom.getRootElement().getChildren(WsnbrConstants.TOPIC_QNAME.getLocalPart(),
    				Namespace.getNamespace(WsnbrConstants.TOPIC_QNAME.getNamespaceURI()));

    		for (Object topExprNode : topExprNodes) {
    			additionalNSPerExp.add(((Element)topExprNode).getAdditionalNamespaces());				
    		}

    		com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationRP JaxbTypeObj =
    			(com.ebmwebsourcing.wsstar.notification.definition.brokered.PublisherRegistrationRP) unmarshaller.unmarshal(doc);
    		result = new PublisherRegistrationRPImpl(JaxbTypeObj,null);

    		List<TopicExpressionType> listOfTopicExpr = result.getTopic();
    		for (TopicExpressionType topExprItem : listOfTopicExpr) {
    			for (Namespace nsItem : additionalNSPerExp.get(listOfTopicExpr.indexOf(topExprItem))) {
    				topExprItem.addTopicNameSpace(nsItem.getPrefix(), nsItem.getURI());
    			}				
    		}


    	} catch (JAXBException e) {
    		throw new WSNotificationException(e);
    	} catch (SchemaException e) {
    		throw new WSNotificationException(e);
    	}		
    	return result;
    }

    /**
     * Unmarshall {@link DestroyRegistrationResponse} object from a {@link Document} representation fragment object 
     *  
     * @param doc {@link org.w3c.dom.Document} object representation of {@link DestroyRegistrationResponse} Java type
     * @return a {@link DestroyRegistrationResponse} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public DestroyRegistrationResponse readDestroyRegistrationResponse(final Document doc) throws WSNotificationException{
    	DestroyRegistrationResponse result = null;
		try {			
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse> schemaBinding =
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse.class);
            result = new DestroyRegistrationResponseImpl(schemaBinding.getValue(),null);
			 */
			com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistrationResponse) unmarshaller.unmarshal(doc);
			result = new DestroyRegistrationResponseImpl(JaxbTypeObj,null);			
		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}		
		return result;	
    }

    /**
     * Unmarshall {@link Subscribe} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link Subscribe} Java type 
     * @return a {@link Subscribe} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public Subscribe readSubscribe(final Document doc) throws WSNotificationException{Subscribe result = null;
    try {			

    	Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

    	// TODO : Check if it is a Thread safe method
    	/*
        final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe> schemaBinding = 
        	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe.class);
        result = new SubscribeImpl(schemaBinding.getValue(),null);
    	 */

    	// just convert:
    	// TODO : replace JDOM and DOM with StaxSource   
    	DOMBuilder builder = new DOMBuilder();
    	org.jdom.Document docAsJDom = builder.build(doc);			

    	//For each NotificationMessage get Topic Node and "extract" topicNS
    	Element topicExpressionNode = docAsJDom.getRootElement().getChild(WsnbConstants.FILTER_QNAME.getLocalPart(),
    			Namespace.getNamespace(WsnbConstants.FILTER_QNAME.getNamespaceURI())).getChild(WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart(),
    					Namespace.getNamespace(WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI()));
    	List<Namespace> additionalTopicsNS = topicExpressionNode.getAdditionalNamespaces();

    	// Process unmarshalling operation :
    	com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe JaxbTypeObj =
    		(com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe) unmarshaller.unmarshal(doc);
    	result = new SubscribeImpl(JaxbTypeObj,null);

    	for (Namespace nsItem : additionalTopicsNS) {
    		result.getFilter().getTopicExpression().addTopicNameSpace(((Namespace)nsItem).getPrefix(), ((Namespace)nsItem).getURI());            	
    	}			

    } catch (JAXBException e) {
    	e.printStackTrace();
    } catch (SchemaException e) {
    	e.printStackTrace();
    }				
    return result;
    }

    /**
     * Unmarshall {@link SubscriptionManagerRP} object from a {@link Document} representation fragment object 
     * 
     * @param file {@link org.w3c.dom.Document} object containing a marshalled {@link SubscriptionManagerRP} Java type 
     * @return a {@link SubscriptionManagerRP} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public SubscriptionManagerRP readSubscriptionManagerRP(final Document doc) throws WSNotificationException{
    	SubscriptionManagerRP result = null;

    	try {			

    		Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

    		// TODO : Check if it is a Thread safe method
    		/*
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe> schemaBinding = 
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.Subscribe.class);
            result = new SubscribeImpl(schemaBinding.getValue(),null);
    		 */

    		// just convert:
    		// TODO : replace JDOM and DOM with StaxSource   
    		DOMBuilder builder = new DOMBuilder();
    		org.jdom.Document docAsJDom = builder.build(doc);			

    		//For each NotificationMessage get Topic Node and "extract" topicNS
    		Element topicExpressionNode = docAsJDom.getRootElement().getChild(WsnbConstants.FILTER_QNAME.getLocalPart(),
    				Namespace.getNamespace(WsnbConstants.FILTER_QNAME.getNamespaceURI())).getChild(WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart(),
    						Namespace.getNamespace(WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI()));
    		List<Namespace> additionalTopicsNS = topicExpressionNode.getAdditionalNamespaces();

    		// Process unmarshalling operation :
    		com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP JaxbTypeObj =
    			(com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionManagerRP) unmarshaller.unmarshal(doc);
    		result = new SubscriptionManagerRPImpl(JaxbTypeObj,null);

    		for (Namespace nsItem : additionalTopicsNS) {
    			result.getFilter().getTopicExpression().addTopicNameSpace(((Namespace)nsItem).getPrefix(), ((Namespace)nsItem).getURI());            	
    		}			

    	} catch (JAXBException e) {
    		e.printStackTrace();
    	} catch (SchemaException e) {
    		e.printStackTrace();
    	}				
    	return result;
    }

    /**
     * Unmarshall {@link SubscribeResponse} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link SubscribeResponse} Java type 
     * @return a {@link SubscribeResponse} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public SubscribeResponse readSubscribeResponse(final Document doc) throws WSNotificationException{
    	SubscribeResponse result = null;
		try {			
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse> schemaBinding =
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse.class);
            result = new SubscribeResponseImpl(schemaBinding.getValue(),null);
			 */
			com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.base.SubscribeResponse) unmarshaller.unmarshal(doc);
			result = new SubscribeResponseImpl(JaxbTypeObj,null);
		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}				
		return result;
    }
    
    /**
     *  Unmarshall {@link Unsubscribe} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link Unsubscribe} Java type
     * @return a {@link Unsubscribe} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public Unsubscribe readUnsubscribe(final Document doc) throws WSNotificationException{
    	Unsubscribe result = null;
		try {
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe> schemaBinding =
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe.class);
            result = new UnsubscribeImpl(schemaBinding.getValue(),null);
			 */
			com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe JaxbTypeObj =
				(com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe) unmarshaller.unmarshal(doc);
			result = new UnsubscribeImpl(JaxbTypeObj,null);
		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}
		return result;
    }
    
    /**
     *  Unmarshall {@link UnsubscribeResponse} object from a {@link Document} representation fragment object 
     * 
     * @param doc org.w3c.dom.Document object representation of {@link UnsubscribeResponse} Java type
     * @return a {@link UnsubscribeResponse} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */
    public UnsubscribeResponse readUnsubscribeResponse(final Document doc) throws WSNotificationException{
    	UnsubscribeResponse result = null;
		try {			
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();
			
			// TODO : Check if it is a Thread safe method
			/*
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse> schemaBinding = 
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse.class);
            result = new UnsubscribeResponseImpl(schemaBinding.getValue(),null);
			 */
			com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse JaxbTypeObj = 
				(com.ebmwebsourcing.wsstar.notification.definition.base.UnsubscribeResponse) unmarshaller.unmarshal(doc);
			result = new UnsubscribeResponseImpl(JaxbTypeObj,null);
		} catch (JAXBException e) {
			e.printStackTrace();
		} catch (SchemaException e) {
			e.printStackTrace();
		}
		return result;

    }
    
    
    /**
     * Unmarshall {@link Notify} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link Notify} Java type
     * @return a {@link Notify} object (type generated with jaxb tools) 
     * @throws WSNotificationException
     */    
    public Notify readNotify(final Document doc) throws WSNotificationException{
    	Notify result = null;
		try {
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			/*
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.Notify> schemaBinding = 
            	this.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.Notify.class);
            result = new NotifyImpl(schemaBinding.getValue(),null);
			 */

			// just convert:
			// TODO : replace JDOM and DOM with StaxSource   
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document docAsJDom = builder.build(doc);

			List<List<Namespace>> additionalTopicNSPerMsg = new ArrayList<List<Namespace>>();

			//For each NotificationMessage get Topic Node and "extract" topicNS
			List<?> notifMsgNodes = docAsJDom.getRootElement().getChildren(WsnbConstants.NOTIFICATION_MSG_QNAME.getLocalPart(),
					Namespace.getNamespace(WsnbConstants.NOTIFICATION_MSG_QNAME.getNamespaceURI()));

			Element currentTopicNode = null;
			for (Object msgNode : notifMsgNodes) {
				currentTopicNode = ((Element)msgNode).getChild(WsnbConstants.TOPIC_QNAME.getLocalPart(),
						Namespace.getNamespace(WsnbConstants.TOPIC_QNAME.getNamespaceURI()));	
				additionalTopicNSPerMsg.add(currentTopicNode.getAdditionalNamespaces());
			}

			// Process unmarshalling operation :
			com.ebmwebsourcing.wsstar.notification.definition.base.Notify JaxbTypeObj = 
				(com.ebmwebsourcing.wsstar.notification.definition.base.Notify) unmarshaller.unmarshal(doc);
			result = new NotifyImpl(JaxbTypeObj,null);

			// set topicNS In corresponding TopicExpression model object
			List<NotificationMessageHolderType> notifMessages = result.getNotificationMessage(); 
			for (NotificationMessageHolderType notifMsgItem : notifMessages) {
				List<Namespace> topicNSToAdd = additionalTopicNSPerMsg.get(notifMessages.indexOf(notifMsgItem));
				for (Namespace currentNs : topicNSToAdd) {
					notifMsgItem.getTopic().addTopicNameSpace(currentNs.getPrefix(),currentNs.getURI());
				}
			}			

		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		} catch (SchemaException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}                    		
		return result;
    }
    
    /**
     * Unmarshall {@link EndpointReferenceType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link EndpointReferenceType} Java type
     * @return a {@link EndpointReferenceType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    
    /**
     * Unmarshall {@link TopicExpressionType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link TopicExpressionType} Java type
     * @return a {@link TopicExpressionType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public TopicExpressionType readTopicExpressionType(final Document doc) throws WSNotificationException{
    	TopicExpressionType result = null;
		try {

			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();
			
			// just convert:
			// TODO : replace JDOM and DOM with StaxSource   
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document docAsJDom = builder.build(doc);

			List<?> additionalNS = docAsJDom.getRootElement().getAdditionalNamespaces();

			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType.class);
			result = new TopicExpressionTypeImpl(schemaBinding.getValue(),null);

			for (Object item : additionalNS) {
				result.addTopicNameSpace(((Namespace)item).getPrefix(), ((Namespace)item).getURI());            	
			}

			/*
           	// TODO : Check if it is a Thread safe method					
			com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType JaxbTypeObj = 
				(com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType) WSNotificationReaderImpl.unmarshaller.unmarshal(doc);
			result = new TopicExpressionTypeImpl(JaxbTypeObj,null);
			 */

		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		} catch (SchemaException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}                    		

		return result;
    }
    
    /**
     * Unmarshall {@link QueryExpressionType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link QueryExpressionType} Java type
     * @return a {@link QueryExpressionType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public QueryExpressionType readQueryExpressionType(final Document doc) throws WSNotificationException{
    	QueryExpressionType result = null;
		try {
		
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();
			
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType.class);
			result = new QueryExpressionTypeImpl(schemaBinding.getValue(),null);
		
		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		}                    		
		return result;
    }
    
    /**
     * Unmarshall {@link TopicType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link TopicType} Java type
     * @return a {@link TopicType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public TopicType readTopicType(final Document doc) throws WSNotificationException{
    	TopicType result = null;
		try {
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType.class);
			result = new TopicTypeImpl(schemaBinding.getValue(),null);
			/*
            final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.Topic> schemaBinding = 
            	WSNotificationReaderImpl.getUnMarshaller().unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.Topic.class);
            result = new TopicTypeImpl(schemaBinding.getValue(),null);
			 */
			/*					
			com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType JaxbTypeObj = 
				(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType) WSNotificationReaderImpl.unmarshaller.unmarshal(doc);
			result = new TopicSetTypeImpl(JaxbTypeObj,null);
			 */

		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		} /*catch (SchemaException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } */                   		
		return result;
    }
    
    /**
     * Unmarshall {@link TopicNamespaceType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link TopicNamespaceType} Java type
     * @return a {@link TopicNamespaceType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public TopicNamespaceType readTopicNamespaceType(final Document doc) throws WSNotificationException{
    	TopicNamespaceType result = null;
		try {
			// TODO : Check if it is a Thread safe method

			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();
			
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType.class);
			result = new TopicNamespaceTypeImpl(schemaBinding.getValue(),null);

			/*
				com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType JaxbTypeObj = 
					(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType) WSNotificationReaderImpl.unmarshaller.unmarshal(doc);
				result = new TopicNamespaceTypeImpl(JaxbTypeObj,null);				
			 */
		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		} /*catch (SchemaException e) {
	            // TODO Auto-generated catch block
	            e.printStackTrace();
	        } */                   		
		return result;
    }
    
    /**
     * Unmarshall {@link TopicSetType} object from a {@link Document} representation fragment object 
     * 
     * @param doc {@link org.w3c.dom.Document} object representation of {@link TopicSetType} Java type
     * @return a {@link TopicSetType} object (type generated with jaxb tools)
     * @throws WSNotificationException
     */
    public TopicSetType readTopicSetType(final Document doc) throws WSNotificationException{
    	TopicSetType result = null;
		try {
			
			Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();
			
			// TODO : Check if it is a Thread safe method

			final JAXBElement<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(doc),com.ebmwebsourcing.wsstar.notification.definition.topics.TopicSetType.class);
			result = new TopicSetTypeImpl(schemaBinding.getValue(),null);

			/*
			com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType JaxbTypeObj = 
				(com.ebmwebsourcing.wsstar.notification.definition.topics.TopicNamespaceType) WSNotificationReaderImpl.unmarshaller.unmarshal(doc);
			result = new TopicNamespaceTypeImpl(JaxbTypeObj,null);				
			 */
		} catch (JAXBException e) {
			//throw new SchemaException(
			//        "Failed to build Java bindings from SchemaImpl descriptor XML document", e);
			e.printStackTrace();
		} /*catch (SchemaException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } */                   		
		return result;
    }
    
    /**
     * method used to restore {@link SubscriptionManagerRP} java object from a file
     * 
     * @param  file the {@link File} which the java Object have been persisted in
     * @return the {@link SubscriptionManagerRP} java Object previously store as a file
     * @throws WSNotificationException
     */
    public SubscriptionManagerRP readSubscriptionManagerRPFromFile(File file) throws WSNotificationException{
	SubscriptionManagerRP result = null;
		
		Document subsRPAsDoc = this.convertFromFiletoDocument(file);
		result = this.readSubscriptionManagerRP(subsRPAsDoc);
		
		return result;
    }
    
    /**
     * method used to restore {@link PublisherRegistrationRP} java object from a file
     * 
     * @param file the {@link File} which the java Object have been persisted in
     * @return the {@link PublisherRegistrationRP} java Object previously store as a file
     * @throws WSNotificationException
     */
    public PublisherRegistrationRP readPublisherRegistrationRPFromFile(File file) throws WSNotificationException{
PublisherRegistrationRP result = null;
		
		Document pubRegRPAsDoc = this.convertFromFiletoDocument(file);
		result = this.readPublisherRegistrationRP(pubRegRPAsDoc);		
		
		return result;
    }
    
    
    private Document convertFromFiletoDocument(File file){
		Document result = null;		
		try{
			DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
			dbfac.setNamespaceAware(true);
			DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
			result = docBuilder.parse(file);
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return result;
	}
}
