/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.utils;


import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.SchemaFactory;

import org.ow2.easywsdl.schema.api.SchemaException;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;


/**
 * This class is a "link" between JAXB generated classes and its upper API.
 * It provides the JAXB context object used to get Unmarshaller/Marshaller
 * Object. See EASYWSDL Library for more details since it follow the same
 * JAXB usage model.  
 *    
 * @author Thierry Déjean - eBM WebSourcing
 */
public class WSNotificationJAXBContext {

    /**
     * The JAXB context
     */
    private JAXBContext jaxbContext;
    
    private String[] additionalsNsAndPrefixesMappings = null;

    /**
     * Default constructor. Private object initializations
     */
    public WSNotificationJAXBContext() throws SchemaException {
        SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
          
        try {
             this.jaxbContext = JAXBContext
             	.newInstance(new Class[] {    		
                		com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.ObjectFactory.class,
                		/*com.ebmwebsourcing.wsstar.addressing.jaxbmodel.addr4notif.ObjectFactory.class,*/
                		/*com.ebmwebsourcing.wsstar.notification.definition.ebmwebsourcing.ObjectFactory.class,*/
                		com.ebmwebsourcing.wsstar.notification.definition.resource.ObjectFactory.class,
                		com.ebmwebsourcing.wsstar.notification.definition.resource.basefaults.ObjectFactory.class,
                		com.ebmwebsourcing.wsstar.notification.definition.resource.properties.ObjectFactory.class,
                		com.ebmwebsourcing.wsstar.notification.definition.resource.lifecycle.ObjectFactory.class,
                		com.ebmwebsourcing.wsstar.notification.definition.topics.ObjectFactory.class,
                		com.ebmwebsourcing.wsstar.notification.definition.base.ObjectFactory.class,
                		com.ebmwebsourcing.wsstar.notification.definition.brokered.ObjectFactory.class});
        } catch (final JAXBException e) {
        	throw new WSNotificationException(e);
        }
    }

    /**
     * jaxbContext attribute getter
	 *
     * @return the jaxbContext -instance of {@link JAXBContext}- attribute value
     */
    public JAXBContext getJaxbContext() {
        return this.jaxbContext;        
    }
    
    /**
     * add custom Prefix/Namesapce mapping Instead of default one which
     * used the default prefix notation : "ns[an_integer]"   
     * 
     * @param nsAndPref
     */
    public void addNsAndPrefixMapping(String[] nsAndPref) {
    	this.additionalsNsAndPrefixesMappings = nsAndPref;
    }
    
    /**
     * Create an instance of {@link Marshaller {@code}} from the
     * current {@link JAXBContext} object 
     * 
     * @return a {@link Marshaller} object
     * @throws JAXBException
     */
    public Marshaller createWSNotificationMarshaller() throws JAXBException{
    	NamespacePrefixMapper wsnMapper = new WSNotificationJAXBPrefixMapper();
    	
    	if (this.additionalsNsAndPrefixesMappings != null) 
    		((WSNotificationJAXBPrefixMapper)wsnMapper).addContextualNamespaceDecls(this.additionalsNsAndPrefixesMappings);
    	
    	Marshaller marshaller = this.jaxbContext.createMarshaller();
    	marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", wsnMapper);    	
    	return marshaller;
    }
  
    /**
     * Create an instance of {@link Unmarshaller {@code}} from the
     * current {@link JAXBContext} object 
     * 
     * @return a a {@link Unmarshaller} object
     * @throws JAXBException
     */
    public Unmarshaller createWSNotificationUnmarshaller() throws JAXBException{
    	Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
    	return unmarshaller;
    }
}
