/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl;

import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class NotificationMessageHolderTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType> implements NotificationMessageHolderType {

	private static final long serialVersionUID = 1L;
	private static Logger log = Logger.getLogger(NotificationMessageHolderTypeImpl.class.getName());

	private EndpointReferenceType eprProducer = null;
	private EndpointReferenceType eprSubscription = null;
	
	public NotificationMessageHolderTypeImpl(final com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType model, AbstractSchemaElementImpl<?> parent) throws WSNotificationException {
		super(model, parent);
		
		try {			
			if (model.getProducerReference() != null)
				this.eprProducer = new EndpointReferenceTypeImpl(model.getProducerReference(),this);
			if (model.getSubscriptionReference() != null)
				this.eprSubscription = new EndpointReferenceTypeImpl(model.getSubscriptionReference(),this);
		} catch (WSAddressingException e) {
			throw new WSNotificationException(e);			
		}
	}

	public Message getMessage() {			
		return (new MessageImpl(this.model.getMessage(),this));//.getContent();	
	}

	public EndpointReferenceType getSubscriptionReference() throws WSNotificationException {
		return this.eprSubscription;
	}

	public TopicExpressionType getTopic() throws WSNotificationException {
		return new TopicExpressionTypeImpl(this.model.getTopic(), null);
	}

	public void setMessage(Message ref) {
		((AbstractSchemaElementImpl<?>)ref).setParent(this);		
		this.model.setMessage(((com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message)(((AbstractSchemaElementImpl<?>)ref).getModel())));
	}

	public void setSubscriptionReference(EndpointReferenceType ref) {
		((AbstractSchemaElementImpl<?>)ref).setParent(this);
		this.eprSubscription = ref;
		this.model.setSubscriptionReference((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl<?>) ref).getModel());
	}

	public void setTopic(TopicExpressionType value) {
		this.model.setTopic((com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType) (((AbstractSchemaElementImpl<?>) value).getModel()));
	}

	public EndpointReferenceType getProducerReference() throws WSNotificationException {
		return this.eprProducer;		
	}

	public void setProducerReference(EndpointReferenceType ref) {				
		((AbstractSchemaElementImpl<?>)ref).setParent(this);
		this.eprProducer = ref;
		this.model.setProducerReference((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl<?>) ref).getModel());
	}

	public static class MessageImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message> implements Message {

		private static final long serialVersionUID = 1L;

		public MessageImpl(final com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message model, AbstractSchemaElementImpl<?> parent) {
			super(model, parent);
		}

		public Element getContent() {				
			Object objFromModel = this.model.getAny();			
			return (objFromModel instanceof Element)? (Element)objFromModel : null;
		}

		public void setContent(Object value) {
			this.model.setAny(value);			
		}

	}
}
