package com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class RenewImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.Renew> implements Renew {

	private static final long serialVersionUID = 1L;

	public RenewImpl(com.ebmwebsourcing.wsstar.notification.definition.base.Renew model, AbstractSchemaElementImpl<?> parent) {
		super(model,parent);
	}
	
	public String getTerminationTime() throws WSNotificationException {		
		return this.model.getTerminationTime();	
	}

	public void setTerminationTime(Date value) throws WSNotificationException {
		
		GregorianCalendar gCal = new GregorianCalendar();
		gCal.setTime(value);
		
		XMLGregorianCalendar xmlGCal;
		try {
			xmlGCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCal);
		} catch (DatatypeConfigurationException e) {			
			throw new WSNotificationException(e);
		}
		
		this.model.setTerminationTime(xmlGCal.toString());
	}

	public void setTerminationTime(Duration value) throws WSNotificationException {
		this.model.setTerminationTime(value.toString());
	}
	
}
