/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.TopicExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class RegisterPublisherImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher> implements RegisterPublisher {

	private static final long serialVersionUID = 1L;
	private EndpointReferenceType eprPublisher = null;

	public RegisterPublisherImpl(final com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisher model, final AbstractSchemaElementImpl parent) throws WSNotificationException {
		super(model, parent);

		try {
			if (model.getPublisherReference() != null) {
				this.eprPublisher = new EndpointReferenceTypeImpl(model.getPublisherReference(),this);
			}
		} catch (final WSAddressingException e) {
			throw new WSNotificationException(e);
		}
	}

	public void addOtherElements(final Element elmt) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

	public EndpointReferenceType getPublisherReference() throws WSNotificationException {
		return this.eprPublisher;
	}

	public void setPublisherReference(final EndpointReferenceType ref) {
		((AbstractSchemaElementImpl)ref).setParent(this);
		this.eprPublisher = ref;
		this.model.setPublisherReference((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl<?>) ref).getModel());
	}

	public boolean isDemand() {
		return this.model.isDemand();
	}

	public void setDemand(final Boolean value) {
		this.model.setDemand(value);
	}

	public Date getInitialTerminationTime() {
		Date result = null;
		final XMLGregorianCalendar initTimeFromModel= this.model.getInitialTerminationTime();
		if (initTimeFromModel != null) {
			result = initTimeFromModel.toGregorianCalendar().getTime();
		}
		return result;
	}

	public void setInitialTerminationTime(final Date value) throws WSNotificationException {

		final GregorianCalendar gCalendar = new GregorianCalendar();
		gCalendar.setTime(value);
		XMLGregorianCalendar xmlCalendar;

		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
			this.model.setInitialTerminationTime(xmlCalendar);
		} catch (final DatatypeConfigurationException e) {
			throw new WSNotificationException(e);
		}
	}

	public List<TopicExpressionType> getTopic() throws WSNotificationException {
		final List<TopicExpressionType> result = new ArrayList<TopicExpressionType>();
		final List<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType> topics = this.model.getTopic();
		for (final com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType topic : topics) {
			result.add(new TopicExpressionTypeImpl(topic, null));
		}
		return result;
	}

	public void addTopic(final TopicExpressionType value) {
		((AbstractSchemaElementImpl)value).setParent(this);
		final List<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType> objFromModel = this.model.getTopic();
		if (objFromModel != null) {
			objFromModel.add((com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType) ((AbstractSchemaElementImpl<?>) value).getModel());
		}
	}
}
