/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.impl;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class RegisterPublisherResponseImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse> implements RegisterPublisherResponse {

	private static final long serialVersionUID = 1L;
	
	private EndpointReferenceType eprConsumer = null;
	private EndpointReferenceType eprRegistration = null;
	
	public RegisterPublisherResponseImpl(final com.ebmwebsourcing.wsstar.notification.definition.brokered.RegisterPublisherResponse model, final AbstractSchemaElementImpl parent) throws WSNotificationException {
		super(model, parent);
		
		try {
			if (model.getConsumerReference() != null)
				this.eprConsumer = new EndpointReferenceTypeImpl(model.getConsumerReference(),this);
			
			if (model.getPublisherRegistrationReference() != null)
				this.eprRegistration = new EndpointReferenceTypeImpl(model.getPublisherRegistrationReference(),this);
			
		} catch (WSAddressingException e) {
			throw new WSNotificationException(e);
		}
	}
	
	public EndpointReferenceType getConsumerReference() throws WSNotificationException {
		return this.eprConsumer;		
	}

	public EndpointReferenceType getPublisherRegistrationReference() throws WSNotificationException {
		return this.eprRegistration;		
	}

	public void setConsumerReference(EndpointReferenceType ref) {
		((AbstractSchemaElementImpl)ref).setParent(this);
		this.eprConsumer = ref;
		this.model.setConsumerReference((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl<?>) ref).getModel());
	}

	public void setPublisherRegistrationReference(EndpointReferenceType ref) {
		((AbstractSchemaElementImpl)ref).setParent(this);
		this.eprRegistration = ref;
		this.model.setPublisherRegistrationReference((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((AbstractSchemaElementImpl<?>) ref).getModel());
	}
}
