/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.definition.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Unsubscribe;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.test.Util;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestWSBaseNotificationDefinition
extends TestCase {
    private static final String DEFAULT_PETALS_ADDRESS = "http://petals.ow2.org/cdk";

    public void testReadNotify() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Notify.xml"));
        System.out.println("\n\t ========== \n testReadNotify() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        Notify descNot = WSNotificationReader.getInstance().readNotify(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check Notify attributs value : \n ");
        Assert.assertNotNull((Object)descNot);
        List msgList = descNot.getNotificationMessage();
        Assert.assertNotNull((Object)msgList);
        for (NotificationMessageHolderType msg : msgList) {
            Message messageContent = msg.getMessage();
            Assert.assertNotNull((Object)messageContent);
            Element content = messageContent.getContent();
            Assert.assertNotNull((Object)content);
            System.out.println(" notification message content : " + XMLPrettyPrinter.prettyPrint((Document)content.getOwnerDocument()));
            TopicExpressionType topic = msg.getTopic();
            Assert.assertNotNull((Object)topic);
            System.out.println(topic.getContent());
            System.out.println(topic.getDialect());
            System.out.println(topic.getTopicNameSpace());
            EndpointReferenceType producerRef = msg.getProducerReference();
            Assert.assertNotNull((Object)producerRef);
            System.out.println(producerRef.getAddress());
            ReferenceParametersType refParam = (ReferenceParametersType)producerRef.getReferenceParameters();
            Assert.assertNotNull((Object)refParam);
            List listOfObj = ((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType)((AbstractSchemaElementImpl)refParam).getModel()).getAny();
            System.out.println("ReferenceParameter content (Element Or JAXBElement Object) : \n");
            for (Object refParObjItem : listOfObj) {
                if (refParObjItem instanceof Element) {
                    System.out.println(" ---> content n\u00b0" + listOfObj.indexOf(refParObjItem) + " : \n" + XMLPrettyPrinter.prettyPrint((Document)((Element)refParObjItem).getOwnerDocument()));
                    continue;
                }
                refParObjItem.toString();
            }
            EndpointReferenceType subscriptionRef = msg.getSubscriptionReference();
            Assert.assertNotNull((Object)subscriptionRef);
            System.out.println(subscriptionRef.getAddress());
            refParam = (ReferenceParametersType)subscriptionRef.getReferenceParameters();
            Assert.assertNotNull((Object)refParam);
            listOfObj = ((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType)((AbstractSchemaElementImpl)refParam).getModel()).getAny();
            System.out.println("ReferenceParameter content (Element Or JAXBElement Object) : \n");
            for (Object refParObjItem : listOfObj) {
                if (refParObjItem instanceof Element) {
                    System.out.println(" ---> content n\u00b0" + listOfObj.indexOf(refParObjItem) + " : \n" + XMLPrettyPrinter.prettyPrint((Document)((Element)refParObjItem).getOwnerDocument()));
                    continue;
                }
                refParObjItem.toString();
            }
        }
    }

    public void testWriteNotif() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Notify.xml"));
        Notify descRead = WSNotificationReader.getInstance().readNotify(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeNotify(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteNotify() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateNotify() throws URISyntaxException, WSNotificationException, WSAddressingException, ParserConfigurationException {
        Notify notifyPayload = WSNotificationFactory.getInstance().createNotify();
        NotificationMessageHolderType msg = WSNotificationFactory.getInstance().createNotificationMessageHolderType();
        Message content = WSNotificationFactory.getInstance().createMessage();
        Document docForMsgContent = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element elt = docForMsgContent.createElementNS("http://anyUri/sample", "NotifyContent");
        elt.setPrefix("npex");
        elt.setTextContent("This is the message content contained in the created notification");
        content.setContent((Object)elt);
        msg.setMessage(content);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("tns1", "http://a/given/topic/namespace");
        topic.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        topic.setContent("tns1:aGivenTopic/toto/subsubtopic/*/trucMuche");
        msg.setTopic(topic);
        EndpointReferenceType registrationRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        registrationRef.setAddress(DEFAULT_PETALS_ADDRESS);
        ReferenceParametersType ref = (ReferenceParametersType)registrationRef.newReferenceParameters();
        registrationRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        msg.setSubscriptionReference(registrationRef);
        EndpointReferenceType producerRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        producerRef.setAddress(DEFAULT_PETALS_ADDRESS);
        ReferenceParametersType refProd = (ReferenceParametersType)producerRef.newReferenceParameters();
        producerRef.setReferenceParameters((AbsItfReferenceParametersType)refProd);
        msg.setProducerReference(producerRef);
        notifyPayload.addNotificationMessage(msg);
        Assert.assertNotNull((Object)notifyPayload);
        Document doc = WSNotificationWriter.getInstance().writeNotify(notifyPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateNotify() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadSubscribe() throws URISyntaxException, WSNotificationException, WSAddressingException {
        System.out.println("\n\t testReadSubscribe() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Subscribe.xml"));
        System.out.println("\n\t ========== \n xml file imported :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        Subscribe descSubs = WSNotificationReader.getInstance().readSubscribe(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check Subscribe attributs value : \n ");
        Assert.assertNotNull((Object)descSubs);
        EndpointReferenceType consumerRef = descSubs.getConsumerReference();
        Assert.assertNotNull((Object)consumerRef);
        Assert.assertEquals((String)DEFAULT_PETALS_ADDRESS, (String)consumerRef.getAddress());
        System.out.println(consumerRef.getAddress());
        ReferenceParametersType refParam = (ReferenceParametersType)consumerRef.getReferenceParameters();
        Assert.assertNotNull((Object)refParam);
        List listOfObj = ((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType)((AbstractSchemaElementImpl)refParam).getModel()).getAny();
        System.out.println("ReferenceParameter content (Element Or JAXBElement Object) : \n");
        for (Object refParObjItem : listOfObj) {
            if (refParObjItem instanceof Element) {
                System.out.println(" ---> content n\u00b0" + listOfObj.indexOf(refParObjItem) + " : \n" + XMLPrettyPrinter.prettyPrint((Document)((Element)refParObjItem).getOwnerDocument()));
                continue;
            }
            refParObjItem.toString();
        }
        Assert.assertNotNull((Object)descSubs.getInitialTerminationTime());
        System.out.println(descSubs.getInitialTerminationTime().toString());
        FilterType filter = descSubs.getFilter();
        Assert.assertNotNull((Object)filter);
        TopicExpressionType topic = filter.getTopicExpression();
        Assert.assertNotNull((Object)topic);
        System.out.println("topic dialect : " + topic.getDialect());
        System.out.println("topic namspace(s) : " + topic.getTopicNameSpace());
        System.out.println("topic content : " + topic.getContent());
        List msgContentList = filter.getMessageContentList();
        Assert.assertNotNull((Object)msgContentList);
        for (QueryExpressionType msgContentItem : msgContentList) {
            System.out.println("msgCtt dialect : " + msgContentItem.getDialect());
            List contents = msgContentItem.getContent();
            Assert.assertNotNull((Object)contents);
            int i = 0;
            for (Element xpathExprItem : contents) {
                System.out.println("msgCtt content " + ++i + " : " + xpathExprItem + "=" + xpathExprItem.getTextContent());
            }
        }
        com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType policy = descSubs.getSubscriptionPolicy();
        Assert.assertNotNull((Object)policy);
        List any = policy.getPolicyRules();
        for (Element item : any) {
            System.out.println("policy element  " + any.indexOf(item) + " : " + item + "=" + XMLPrettyPrinter.prettyPrint((Document)item.getOwnerDocument()));
        }
    }

    public void testWriterSubscribe() throws URISyntaxException, WSNotificationException {
        System.out.println("\n\t testWriterSubscribe() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Subscribe.xml"));
        Subscribe subs = WSNotificationReader.getInstance().readSubscribe(docDesc);
        Assert.assertNotNull((Object)subs);
        Document docWrotten = WSNotificationWriter.getInstance().writeSubscribe(subs);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n \n testWriteSubscribe() - payload written  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateSubscribe() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Subscribe subscribePayload = WSNotificationFactory.getInstance().createSubscribe();
        GregorianCalendar gCalendar = new GregorianCalendar();
        subscribePayload.setInitialTerminationTime(gCalendar.getTime());
        EndpointReferenceType consumerEdpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        consumerEdpRef.setAddress(DEFAULT_PETALS_ADDRESS);
        ReferenceParametersType ref = (ReferenceParametersType)consumerEdpRef.newReferenceParameters();
        consumerEdpRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        subscribePayload.setConsumerReference(consumerEdpRef);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("tns1", "http://a/given/topic/namespace");
        topic.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        topic.setContent("tns1:aGivenTopic/toto/subsubtopic/*");
        QueryExpressionType msgCtt = WSNotificationFactory.getInstance().createQueryExpressionType();
        msgCtt.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        FilterType filter = WSNotificationFactory.getInstance().createFiltertype();
        filter.setTopicExpression(topic);
        filter.addMessageContent(msgCtt);
        subscribePayload.setFilter(filter);
        com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType policy = WSNotificationFactory.getInstance().createSubscriptionPolicyType();
        Element elementDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/policyRule_grdr-etape1.xsl")).getDocumentElement();
        ((SubscriptionPolicyType)((AbstractSchemaElementImpl)policy).getModel()).getAny().add(elementDesc);
        System.out.println("\n\t ========== \n xml xslt stylesheet imported :\n" + XMLPrettyPrinter.prettyPrint((Document)elementDesc.getOwnerDocument()));
        subscribePayload.setSubscriptionPolicy(policy);
        Assert.assertNotNull((Object)subscribePayload);
        Document doc = WSNotificationWriter.getInstance().writeSubscribe(subscribePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateSubscribe() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
        Subscribe subs = WSNotificationReader.getInstance().readSubscribe(doc);
        Assert.assertNotNull((Object)subs);
        Document docWrotten = WSNotificationWriter.getInstance().writeSubscribe(subs);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n \n Read and Display the Subscribe() - payload created - :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testReadSubscriptionManagerRP() throws URISyntaxException, WSNotificationException, WSAddressingException {
        System.out.println("\n\t testReadSubscriptionManagerRP() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/SubscriptionManagerRP.xml"));
        System.out.println("\n\t ========== \n xml file imported :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        SubscriptionManagerRP descSubsManRP = WSNotificationReader.getInstance().readSubscriptionManagerRP(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check SubscriptionManagerRP attributs value : \n ");
        Assert.assertNotNull((Object)descSubsManRP);
        EndpointReferenceType consumerRef = descSubsManRP.getConsumerReference();
        Assert.assertNotNull((Object)consumerRef);
        Assert.assertEquals((String)DEFAULT_PETALS_ADDRESS, (String)consumerRef.getAddress());
        System.out.println(consumerRef.getAddress());
        ReferenceParametersType refParam = (ReferenceParametersType)consumerRef.getReferenceParameters();
        Assert.assertNotNull((Object)refParam);
        List listOfObj = ((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType)((AbstractSchemaElementImpl)refParam).getModel()).getAny();
        System.out.println("ReferenceParameter content (Element Or JAXBElement Object) : \n");
        for (Object refParObjItem : listOfObj) {
            if (refParObjItem instanceof Element) {
                System.out.println(" ---> content n\u00b0" + listOfObj.indexOf(refParObjItem) + " : \n" + XMLPrettyPrinter.prettyPrint((Document)((Element)refParObjItem).getOwnerDocument()));
                continue;
            }
            refParObjItem.toString();
        }
        Assert.assertNotNull((Object)descSubsManRP.getCreationTime());
        System.out.println("subscription Creation Date : " + descSubsManRP.getCreationTime().toString());
        FilterType filter = descSubsManRP.getFilter();
        Assert.assertNotNull((Object)filter);
        TopicExpressionType topic = filter.getTopicExpression();
        Assert.assertNotNull((Object)topic);
        System.out.println("topic dialect : " + topic.getDialect());
        System.out.println("topic namspace(s) : " + topic.getTopicNameSpace());
        System.out.println("topic content : " + topic.getContent());
        List msgContentList = filter.getMessageContentList();
        Assert.assertNotNull((Object)msgContentList);
        for (QueryExpressionType msgContentItem : msgContentList) {
            System.out.println("msgCtt dialect : " + msgContentItem.getDialect());
            List contents = msgContentItem.getContent();
            Assert.assertNotNull((Object)contents);
            int i = 0;
            for (Element xpathExprItem : contents) {
                System.out.println("msgCtt content " + ++i + " : " + xpathExprItem + "=" + xpathExprItem.getTextContent());
            }
        }
        com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType policy = descSubsManRP.getSubscriptionPolicy();
        Assert.assertNotNull((Object)policy);
        List any = policy.getPolicyRules();
        for (Element item : any) {
            System.out.println("policy element  " + any.indexOf(item) + " : " + item + "=" + XMLPrettyPrinter.prettyPrint((Document)item.getOwnerDocument()));
        }
    }

    public void testWriterSubscriptionManagerRP() throws URISyntaxException, WSNotificationException {
        System.out.println("\n\t testWriterSubscriptionManagerRP() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/SubscriptionManagerRP.xml"));
        SubscriptionManagerRP subsManRP = WSNotificationReader.getInstance().readSubscriptionManagerRP(docDesc);
        Assert.assertNotNull((Object)subsManRP);
        Document docWrotten = WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subsManRP);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n \n testWriteSubscriptionManagerRP() - payload written  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateSubscriptionManagerRP() throws URISyntaxException, WSNotificationException, WSAddressingException {
        SubscriptionManagerRP subscriptionManagerRPPayload = WSNotificationFactory.getInstance().createSubscriptionManagerRP();
        GregorianCalendar gCalendar = new GregorianCalendar();
        subscriptionManagerRPPayload.setCreationTime(gCalendar.getTime());
        EndpointReferenceType consumerEdpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        consumerEdpRef.setAddress(DEFAULT_PETALS_ADDRESS);
        ReferenceParametersType ref = (ReferenceParametersType)consumerEdpRef.newReferenceParameters();
        consumerEdpRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        subscriptionManagerRPPayload.setConsumerReference(consumerEdpRef);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("tns1", "http://a/given/topic/namespace");
        topic.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        topic.setContent("tns1:aGivenTopic/toto/subsubtopic/*");
        QueryExpressionType msgCtt = WSNotificationFactory.getInstance().createQueryExpressionType();
        msgCtt.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        FilterType filter = WSNotificationFactory.getInstance().createFiltertype();
        filter.setTopicExpression(topic);
        filter.addMessageContent(msgCtt);
        subscriptionManagerRPPayload.setFilter(filter);
        com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType policy = WSNotificationFactory.getInstance().createSubscriptionPolicyType();
        Element elementDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/policyRule_grdr-etape1.xsl")).getDocumentElement();
        ((SubscriptionPolicyType)((AbstractSchemaElementImpl)policy).getModel()).getAny().add(elementDesc);
        System.out.println("\n\t ========== \n xml xslt stylesheet imported :\n" + XMLPrettyPrinter.prettyPrint((Document)elementDesc.getOwnerDocument()));
        subscriptionManagerRPPayload.setSubscriptionPolicy(policy);
        Assert.assertNotNull((Object)subscriptionManagerRPPayload);
        Document doc = WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subscriptionManagerRPPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateSubscriptionManager() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
        SubscriptionManagerRP subs = WSNotificationReader.getInstance().readSubscriptionManagerRP(doc);
        Assert.assertNotNull((Object)subs);
        Document docWrotten = WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subs);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n \n Read and Display the SubscriptionManagerRP() - payload created - :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testReadSubscribeResponse() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/SubscribeResponse.xml"));
        System.out.println("\n\t ========== \n \n testReadSubscribeResponse() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        SubscribeResponse descSubsResp = WSNotificationReader.getInstance().readSubscribeResponse(docDesc);
        Assert.assertNotNull((Object)descSubsResp);
        EndpointReferenceType susbcriptionRef = descSubsResp.getSubscriptionReference();
        Assert.assertNotNull((Object)susbcriptionRef);
        System.out.println(susbcriptionRef.getAddress());
        ReferenceParametersType refParam = (ReferenceParametersType)susbcriptionRef.getReferenceParameters();
        Assert.assertNotNull((Object)refParam);
        List listOfObj = ((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType)((AbstractSchemaElementImpl)refParam).getModel()).getAny();
        System.out.println("ReferenceParameter content (Element Or JAXBElement Object) : \n");
        for (Object refParObjItem : listOfObj) {
            if (refParObjItem instanceof Element) {
                System.out.println(" ---> content n\u00b0" + listOfObj.indexOf(refParObjItem) + " : \n" + XMLPrettyPrinter.prettyPrint((Document)((Element)refParObjItem).getOwnerDocument()));
                continue;
            }
            refParObjItem.toString();
        }
    }

    public void testWriterSubscribeResponse() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/SubscribeResponse.xml"));
        SubscribeResponse descRead = WSNotificationReader.getInstance().readSubscribeResponse(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeSubscribeResponse(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteSubscribeResponse() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateSubscribeResponse() throws URISyntaxException, WSNotificationException, WSAddressingException, DatatypeConfigurationException {
        SubscribeResponse subscribeResponsePayload = WSNotificationFactory.getInstance().createSubscribeResponse();
        EndpointReferenceType subscriptionRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        subscriptionRef.setAddress(DEFAULT_PETALS_ADDRESS);
        ReferenceParametersType ref = (ReferenceParametersType)subscriptionRef.newReferenceParameters();
        subscriptionRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        subscribeResponsePayload.setSubscriptionReference(subscriptionRef);
        subscribeResponsePayload.setCurrentTime(new GregorianCalendar().getTime());
        Date terminationTime = new GregorianCalendar().getTime();
        DatatypeFactory.newInstance().newDuration("PT15M30S").addTo(terminationTime);
        subscribeResponsePayload.setTerminationTime(terminationTime);
        Assert.assertNotNull((Object)subscribeResponsePayload);
        Document doc = WSNotificationWriter.getInstance().writeSubscribeResponse(subscribeResponsePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateSubscribeResponse() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadGetCurrentMessage() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/GetCurrentMessage.xml"));
        System.out.println("\n\t ========== \n testReadGetCurrentMessage() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        GetCurrentMessage descGetCurMsg = WSNotificationReader.getInstance().readGetCurrentMessage(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check GetCurrentMessage attributs value : \n ");
        Assert.assertNotNull((Object)descGetCurMsg);
        TopicExpressionType topic = descGetCurMsg.getTopic();
        Assert.assertNotNull((Object)topic);
        System.out.println(topic.getContent());
        System.out.println(topic.getDialect());
        System.out.println(topic.getTopicNameSpace());
    }

    public void testWriteGetCurrentMessage() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/GetCurrentMessage.xml"));
        GetCurrentMessage descRead = WSNotificationReader.getInstance().readGetCurrentMessage(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeGetCurrentMessage(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteGetCurrentMessage() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateGetCurrentMessage() throws URISyntaxException, WSNotificationException, WSAddressingException, ParserConfigurationException {
        GetCurrentMessage getCurrentMessagePayload = WSNotificationFactory.getInstance().createGetCurrentMessage();
        Assert.assertNotNull((Object)getCurrentMessagePayload);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        Assert.assertNotNull((Object)topic);
        topic.addTopicNameSpace("tns1", "http://a/given/topic/namespace");
        topic.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        topic.setContent("tns1:aGivenTopic/For/GetCurrentMessage/Test/*/trucMuche");
        getCurrentMessagePayload.setTopic(topic);
        Document doc = WSNotificationWriter.getInstance().writeGetCurrentMessage(getCurrentMessagePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateGetCurrentMessage() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadGetCurrentMessageResponse() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/GetCurrentMessageResponse.xml"));
        System.out.println("\n\t ========== \n testReadGetCurrentMessageResponse() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        GetCurrentMessageResponse descGetCurMsg = WSNotificationReader.getInstance().readGetCurrentMessageResponse(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check GetCurrentMessageResponse attributs value : \n ");
        Assert.assertNotNull((Object)descGetCurMsg);
        Message messageContent = descGetCurMsg.getNotifMessageContent();
        Assert.assertNotNull((Object)messageContent);
        Element content = messageContent.getContent();
        Assert.assertNotNull((Object)content);
        System.out.println(" current notify message content : " + XMLPrettyPrinter.prettyPrint((Document)content.getOwnerDocument()));
    }

    public void testWriteGetCurrentMessageResponse() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/GetCurrentMessageResponse.xml"));
        GetCurrentMessageResponse descRead = WSNotificationReader.getInstance().readGetCurrentMessageResponse(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeGetCurrentMessageResponse(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteGetCurrentMessageResponse() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateGetCurrentMessageResponse() throws URISyntaxException, WSNotificationException, WSAddressingException, ParserConfigurationException {
        GetCurrentMessageResponse getCurrentMessageResponsePayload = WSNotificationFactory.getInstance().createGetCurrentMessageResponse();
        Assert.assertNotNull((Object)getCurrentMessageResponsePayload);
        Message content = WSNotificationFactory.getInstance().createMessage();
        Document docForMsgContent = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element elt = docForMsgContent.createElementNS("http://anyUri/sample", "CurrentNotifyContent");
        elt.setPrefix("npex");
        elt.setTextContent("This is the current message content contained the last notify Payload sent !");
        content.setContent((Object)elt);
        getCurrentMessageResponsePayload.setNotifMessageContent(content);
        Document doc = WSNotificationWriter.getInstance().writeGetCurrentMessageResponse(getCurrentMessageResponsePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateGetCurrentMessageResponse() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadUnsubscribe() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Unsubscribe.xml"));
        System.out.println("\n\t ========== \n \n testReadUnsubscribe() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe descUnsubs = WSNotificationReader.getInstance().readUnsubscribe(docDesc);
        Assert.assertNotNull((Object)descUnsubs);
        List listOfObj = ((Unsubscribe)((AbstractSchemaElementImpl)descUnsubs).getModel()).getAny();
        System.out.println("Unsubscribe content (Element Or JAXBElement Object) : \n");
        for (Object refParObjItem : listOfObj) {
            if (refParObjItem instanceof Element) {
                System.out.println(" ---> content n\u00b0" + listOfObj.indexOf(refParObjItem) + " : \n" + XMLPrettyPrinter.prettyPrint((Document)((Element)refParObjItem).getOwnerDocument()));
                continue;
            }
            refParObjItem.toString();
        }
    }

    public void testWriterUnsubscribe() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Unsubscribe.xml"));
        com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe descRead = WSNotificationReader.getInstance().readUnsubscribe(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeUnsubscribe(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteUnsubscribe() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateUnsubscribe() throws URISyntaxException, WSNotificationException, WSAddressingException {
        com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe unsubscribePayload = WSNotificationFactory.getInstance().createUnsubscribe();
        EndpointReferenceType edpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        edpRef.setAddress("mail-address-sample@ebmwebsourcing.com");
        Document edpAsDoc = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(edpRef);
        ((Unsubscribe)((AbstractSchemaElementImpl)unsubscribePayload).getModel()).getAny().add(edpAsDoc.getDocumentElement());
        Document doc = WSNotificationWriter.getInstance().writeUnsubscribe(unsubscribePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateUnsubscribe() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadUnsubscribeResponse() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/UnsubscribeResponse.xml"));
        System.out.println("\n\t ========== \n \n testReadUnsubscribeResponse() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        UnsubscribeResponse descUnsubsResp = WSNotificationReader.getInstance().readUnsubscribeResponse(docDesc);
        Assert.assertNotNull((Object)descUnsubsResp);
    }

    public void testWriterUnsubscribeResponse() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/UnsubscribeResponse.xml"));
        UnsubscribeResponse descRead = WSNotificationReader.getInstance().readUnsubscribeResponse(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeUnsubscribeResponse(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteUnsubscribeResponse() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateUnsubscribeResponse() throws URISyntaxException, WSNotificationException, WSAddressingException {
        UnsubscribeResponse unsubscribeResponsePayload = WSNotificationFactory.getInstance().createUnsubscribeResponse();
        Document doc = WSNotificationWriter.getInstance().writeUnsubscribeResponse(unsubscribeResponsePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateUnsubscribeResponse() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadRenew() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Renew.xml"));
        System.out.println("\n\t ========== \n \n testReadRenew() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        Renew descRenew = WSNotificationReader.getInstance().readRenew(docDesc);
        Assert.assertNotNull((Object)descRenew);
        System.out.println("new termination time : " + descRenew.getTerminationTime());
    }

    public void testWriterRenew() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Renew.xml"));
        Renew descRead = WSNotificationReader.getInstance().readRenew(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeRenew(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteRenew() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateRenewWithDate() throws URISyntaxException, WSNotificationException, WSAddressingException, DatatypeConfigurationException {
        Renew renewPayload = WSNotificationFactory.getInstance().createRenew();
        Date termTimeVal = new GregorianCalendar().getTime();
        DatatypeFactory.newInstance().newDuration("P1YT35M").addTo(termTimeVal);
        renewPayload.setTerminationTime(termTimeVal);
        Document doc = WSNotificationWriter.getInstance().writeRenew(renewPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateUnsubscribe() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testCreateRenewWithDuration() throws URISyntaxException, WSNotificationException, WSAddressingException, DatatypeConfigurationException {
        Renew renewPayload = WSNotificationFactory.getInstance().createRenew();
        Duration termTimeVal = DatatypeFactory.newInstance().newDuration("PT35M");
        renewPayload.setTerminationTime(termTimeVal);
        Document doc = WSNotificationWriter.getInstance().writeRenew(renewPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateUnsubscribe() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadRenewResponse() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/RenewResponse.xml"));
        System.out.println("\n\t ========== \n \n testReadRenewResponse() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        RenewResponse descRenewResponse = WSNotificationReader.getInstance().readRenewResponse(docDesc);
        Assert.assertNotNull((Object)descRenewResponse);
        System.out.println("current time : " + descRenewResponse.getCurrentTime());
        System.out.println("new termination time : " + descRenewResponse.getTerminationTime());
    }

    public void testWriterRenewResponse() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/RenewResponse.xml"));
        RenewResponse descRead = WSNotificationReader.getInstance().readRenewResponse(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeRenewResponse(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteRenewResponse() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateRenewResponse() throws URISyntaxException, WSNotificationException, WSAddressingException, DatatypeConfigurationException {
        RenewResponse renewRespPayload = WSNotificationFactory.getInstance().createRenewResponse();
        Date timeVal = new GregorianCalendar().getTime();
        renewRespPayload.setCurrentTime(timeVal);
        DatatypeFactory.newInstance().newDuration("PT35M").addTo(timeVal);
        renewRespPayload.setTerminationTime(timeVal);
        Document doc = WSNotificationWriter.getInstance().writeRenewResponse(renewRespPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateRenewResponse() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadTopicExpression() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/TopicExpression.xml"));
        System.out.println("\n\t ========== \n \n testReadTopicExpression() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        TopicExpressionType descTopicExpr = WSNotificationReader.getInstance().readTopicExpressionType(docDesc);
        Assert.assertNotNull((Object)descTopicExpr);
        System.out.println("Dialect : " + descTopicExpr.getDialect());
        System.out.println("TopicNamespace(s) : " + descTopicExpr.getTopicNameSpace());
        System.out.println("Topic value : " + descTopicExpr.getContent());
    }

    public void testWriterTopicExpression() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/TopicExpression.xml"));
        TopicExpressionType descRead = WSNotificationReader.getInstance().readTopicExpressionType(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeTopicExpressionType(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteTopicExpression() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateTopicExpression() throws URISyntaxException, WSNotificationException, WSAddressingException {
        TopicExpressionType topicExpress = WSNotificationFactory.getInstance().createTopicExpressionType();
        topicExpress.addTopicNameSpace("tns1", "http://petals.ow2.org/genericnamespace");
        topicExpress.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        topicExpress.setContent("tns1:rootTopic/*/monitoring");
        Document doc = WSNotificationWriter.getInstance().writeTopicExpressionType(topicExpress);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateTopicExpression() - created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadQueryExpression() throws URISyntaxException, WSNotificationException, WSAddressingException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/MessageContent.xml"));
        System.out.println("\n\t ========== \n \n testReadQueryExpression() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        QueryExpressionType descQueryExpr = WSNotificationReader.getInstance().readQueryExpressionType(docDesc);
        Assert.assertNotNull((Object)descQueryExpr);
        System.out.println("Dialect : " + descQueryExpr.getDialect());
        System.out.println("message content value : " + descQueryExpr.getContent());
    }

    public void testWriterQueryExpression() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/MessageContent.xml"));
        QueryExpressionType descRead = WSNotificationReader.getInstance().readQueryExpressionType(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeQueryExpressionType(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteQueryExpression() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateQueryExpression() throws URISyntaxException, WSNotificationException, WSAddressingException {
        QueryExpressionType msgContent = WSNotificationFactory.getInstance().createQueryExpressionType();
        msgContent.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        QName xpathExprEltQName = new QName("http://www.ebmwebsourcing.com/specific/policy", "XpathExpression", "ebm-pol");
        JAXBElement xpathExpElt = WSNotificationFactory.getInstance().createStringJaxbElt(xpathExprEltQName, "/Catalog/Album[@artist=\"Kings Of Leon\"]/Track");
        msgContent.addContent((Object)xpathExpElt);
        Document doc = WSNotificationWriter.getInstance().writeQueryExpressionType(msgContent);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateQueryExpression() - created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testPersistAndRestoreSubsciptionRP() {
        try {
            File[] storedRegFiles;
            String tempDirName = "tmp" + File.separatorChar;
            String persistenceRepositoryName = tempDirName + "SaveSubscriptionManagerRP" + File.separatorChar;
            File persistenceRepository = new File(persistenceRepositoryName);
            persistenceRepository.mkdirs();
            Document request = Util.fromStreamToDocument(TestWSBaseNotificationDefinition.class.getResourceAsStream("/descriptors/Subscribe.xml"));
            Subscribe subsPayload = WSNotificationReader.getInstance().readSubscribe(request);
            SubscriptionManagerRP subscriptionToPersist = WSNotificationFactory.getInstance().createSubscriptionManagerRP();
            subscriptionToPersist.setConsumerReference(subsPayload.getConsumerReference());
            FilterType ft = subsPayload.getFilter();
            subscriptionToPersist.setFilter(ft);
            subscriptionToPersist.setSubscriptionPolicy(subsPayload.getSubscriptionPolicy());
            int nbOfReg = new Random().nextInt(5) + 1;
            System.out.println("[INFO : generate " + nbOfReg + " registration to store)");
            for (int i = 0; i < nbOfReg; ++i) {
                subscriptionToPersist.setCreationTime(new GregorianCalendar().getTime());
                File fileToSaveTo = new File("tmp" + File.separatorChar + "SaveSubscriptionManagerRP" + File.separatorChar + UUID.randomUUID());
                WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subscriptionToPersist, fileToSaveTo);
            }
            if (persistenceRepository.exists() && persistenceRepository.isDirectory()) {
                File[] persistedSubscriptions = persistenceRepository.listFiles();
                Document docRep = null;
                System.out.println(" ########### Liste des subscription restaur\u00e9es : ###########");
                for (int i = 0; i < persistedSubscriptions.length; ++i) {
                    SubscriptionManagerRP subsRP = WSNotificationReader.getInstance().readSubscriptionManagerRP(persistedSubscriptions[i]);
                    docRep = WSNotificationWriter.getInstance().writeSubscriptionManagerRP(subsRP);
                    System.out.println(" ########## Restored Subscription " + persistedSubscriptions[i].getName() + ":\n\n" + XMLPrettyPrinter.prettyPrint((Document)docRep) + "\n");
                }
                System.out.println(" ########### Fin de List  ###########");
            }
            for (File fileItem : storedRegFiles = persistenceRepository.listFiles()) {
                fileItem.delete();
            }
            persistenceRepository.delete();
            new File(tempDirName).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

