/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.extension.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ActionType;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType;
import com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType;
import com.ebmwebsourcing.wsstar.notification.extension.inout.WSNotificationExtensionReader;
import com.ebmwebsourcing.wsstar.notification.extension.inout.WSNotificationExtensionWriter;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TestWSNotificationExtension
extends TestCase {
    private Document convertFromStreamToDocument(InputStream stream) {
        Document result = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            result = builder.parse(stream);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    public void testReadSOAParameter() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testReadSOAParameter() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/SOAParameter.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        SOAParameterType soaParameterObj = WSNotificationExtensionReader.getInstance().readSOAParameterType(docDesc);
        System.out.println("\n ~ Results : ~ \n");
        System.out.println("Check SOAParameter attributs value : \n ");
        Assert.assertNotNull((Object)soaParameterObj);
        QName serviceQName = soaParameterObj.getService();
        Assert.assertNotNull((Object)serviceQName);
        System.out.println("Service QName : " + serviceQName);
        QName interfaceQName = soaParameterObj.getInterface();
        Assert.assertNotNull((Object)interfaceQName);
        System.out.println("Interface QName : " + interfaceQName);
        String endpoint = soaParameterObj.getEndpoint();
        Assert.assertNotNull((Object)endpoint);
        System.out.println("Endpoint Name : " + endpoint);
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testWriteSOAParameter() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testWriteSOAParameter() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/SOAParameter.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        SOAParameterType soaParameterAsObj = WSNotificationExtensionReader.getInstance().readSOAParameterType(docDesc);
        Assert.assertNotNull((Object)soaParameterAsObj);
        System.out.println("\n ~ Results : ~ \n");
        Document soaParamAsDoc = WSNotificationExtensionWriter.getInstance().writeSOAParameterType(soaParameterAsObj);
        Assert.assertNotNull((Object)soaParamAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)soaParamAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~~~ \n");
    }

    public void testCreateSOAParameter() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testCreateSOAParameter() method output results : ~~\n");
        SOAParameterType soaParameterAsObj = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        Assert.assertNotNull((Object)soaParameterAsObj);
        soaParameterAsObj.setEndpoint("MyPersonalServiceEndpoint");
        soaParameterAsObj.setInterface(new QName("http://www.ebmwebsourcing.com/sampleNamesapceUri", "MyPersonalInterface"));
        soaParameterAsObj.setService(new QName("http://www.ebmwebsourcing.com/sampleNamesapceUri", "MyPersonalService"));
        System.out.println("\n ~ Results : ~ \n");
        Document soaParamAsDoc = WSNotificationExtensionWriter.getInstance().writeSOAParameterType(soaParameterAsObj);
        Assert.assertNotNull((Object)soaParamAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)soaParamAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testReadResourcesUuid() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testReadResourcesUuid() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/ResourcesUuid.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        ResourcesUuidType resourcesUuidObj = WSNotificationExtensionReader.getInstance().readResourcesUuidType(docDesc);
        System.out.println("\n ~ Results : ~ \n");
        System.out.println("Check ResourcesUuid attributs value : \n ");
        Assert.assertNotNull((Object)resourcesUuidObj);
        List uuidsList = resourcesUuidObj.getUuids();
        Assert.assertNotNull((Object)uuidsList);
        System.out.println("Uuids list :");
        for (String uuidItem : uuidsList) {
            System.out.println("--> uuid n\u00b0 " + (uuidsList.indexOf(uuidItem) + 1) + ": " + uuidItem);
        }
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testWriteResourcesUuid() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testWriteResourcesUuid() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/ResourcesUuid.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        ResourcesUuidType resourcesUuidAsObj = WSNotificationExtensionReader.getInstance().readResourcesUuidType(docDesc);
        Assert.assertNotNull((Object)resourcesUuidAsObj);
        System.out.println("\n ~ Results : ~ \n");
        Document resourcesUuidAsDoc = WSNotificationExtensionWriter.getInstance().writeResourcesUuidType(resourcesUuidAsObj);
        Assert.assertNotNull((Object)resourcesUuidAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)resourcesUuidAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~~~ \n");
    }

    public void testCreateResourcesUuid() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testCreateResourcesUuid() method output results : ~~\n");
        ResourcesUuidType resourcesUuidAsObj = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        Assert.assertNotNull((Object)resourcesUuidAsObj);
        resourcesUuidAsObj.addUuid("uuid:abdef455-486e-4cb0-e6aa-0ecc76a92eb1");
        resourcesUuidAsObj.addUuid("uuid:f6324db3-aaaa-46ba-a6aa-eecc76a92eb1");
        resourcesUuidAsObj.addUuid("uuid:c6324db3-486e-\u00e96b0-46aa-fefdfe223e33");
        System.out.println("\n ~ Results : ~ \n");
        Document resourcesUuidAsDoc = WSNotificationExtensionWriter.getInstance().writeResourcesUuidType(resourcesUuidAsObj);
        Assert.assertNotNull((Object)resourcesUuidAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)resourcesUuidAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testReadProcessPolicy() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testReadProcessPolicy() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/ProcessPolicy.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        ProcessPolicyType processPolicyObj = WSNotificationExtensionReader.getInstance().readProcessPolicyType(docDesc);
        System.out.println("\n ~ Results : ~ \n");
        System.out.println("Check processPolicyObj attributs value : \n ");
        Assert.assertNotNull((Object)processPolicyObj);
        List processTypeList = processPolicyObj.getAction();
        Assert.assertNotNull((Object)processTypeList);
        System.out.println("process type list :");
        for (ActionType processTypeItem : processTypeList) {
            System.out.println("--> processType n\u00b0 " + (processTypeList.indexOf(processTypeItem) + 1) + ": " + processTypeItem);
        }
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testWriteProcessPolicy() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testWriteProcessPolicy() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/ProcessPolicy.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        ProcessPolicyType processPolicyAsObj = WSNotificationExtensionReader.getInstance().readProcessPolicyType(docDesc);
        Assert.assertNotNull((Object)processPolicyAsObj);
        System.out.println("\n ~ Results : ~ \n");
        Document processPolicyAsDoc = WSNotificationExtensionWriter.getInstance().writeProcessPolicyType(processPolicyAsObj);
        Assert.assertNotNull((Object)processPolicyAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)processPolicyAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~~~ \n");
    }

    public void testCreateProcessPolicy() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testCreateProcessPolicy() method output results : ~~\n");
        ProcessPolicyType processPolicyAsObj = WSNotificationExtensionFactory.getInstance().createProcessPolicyType();
        Assert.assertNotNull((Object)processPolicyAsObj);
        processPolicyAsObj.addAction(ActionType.CREATE);
        System.out.println("\n ~ Results : ~ \n");
        Document processPolicyAsDoc = WSNotificationExtensionWriter.getInstance().writeProcessPolicyType(processPolicyAsObj);
        Assert.assertNotNull((Object)processPolicyAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)processPolicyAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testReadContextPolicy() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testReadContextPolicy() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/ContextPolicy.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        ContextPolicyType contextPolicyObj = WSNotificationExtensionReader.getInstance().readContextPolicyType(docDesc);
        System.out.println("\n ~ Results : ~ \n");
        System.out.println("Check contextPolicyObj attributs value : \n ");
        Assert.assertNotNull((Object)contextPolicyObj);
        System.out.println("Context attribute value type list :");
        System.out.println("correlationId = " + Boolean.toString(contextPolicyObj.isCorrelationId()));
        System.out.println("endpoint = " + Boolean.toString(contextPolicyObj.isEndpoint()));
        System.out.println("interface = " + Boolean.toString(contextPolicyObj.isInterface()));
        System.out.println("meuuid = " + Boolean.toString(contextPolicyObj.isMeuuid()));
        System.out.println("notifDate = " + Boolean.toString(contextPolicyObj.isNotifDate()));
        System.out.println("service = " + Boolean.toString(contextPolicyObj.isService()));
        System.out.println("status = " + Boolean.toString(contextPolicyObj.isStatus()));
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testWriteContextPolicy() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testWriteContextPolicy() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/ContextPolicy.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        ContextPolicyType contextPolicyAsObj = WSNotificationExtensionReader.getInstance().readContextPolicyType(docDesc);
        Assert.assertNotNull((Object)contextPolicyAsObj);
        System.out.println("\n ~ Results : ~ \n");
        Document contextPolicyAsDoc = WSNotificationExtensionWriter.getInstance().writeContextPolicyType(contextPolicyAsObj);
        Assert.assertNotNull((Object)contextPolicyAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)contextPolicyAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~~~ \n");
    }

    public void testCreateContextPolicy() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testCreateContextPolicy() method output results : ~~\n");
        ContextPolicyType contextPolicyAsObj = WSNotificationExtensionFactory.getInstance().createContextPolicyType();
        Assert.assertNotNull((Object)contextPolicyAsObj);
        contextPolicyAsObj.setCorrelationId(Boolean.valueOf(true));
        contextPolicyAsObj.setEndpoint(Boolean.valueOf(true));
        contextPolicyAsObj.setInterface(Boolean.valueOf(true));
        contextPolicyAsObj.setMeuuid(Boolean.valueOf(true));
        contextPolicyAsObj.setNotifDate(Boolean.valueOf(true));
        contextPolicyAsObj.setService(Boolean.valueOf(true));
        contextPolicyAsObj.setStatus(Boolean.valueOf(true));
        System.out.println("\n ~ Results : ~ \n");
        Document processPolicyAsDoc = WSNotificationExtensionWriter.getInstance().writeContextPolicyType(contextPolicyAsObj);
        Assert.assertNotNull((Object)processPolicyAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)processPolicyAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testReadTransformPolicy() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testReadTransformPolicy() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/TransformPolicy.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        XsltStyleSheetType transformPolicyObj = WSNotificationExtensionReader.getInstance().readXsltStyleSheetType(docDesc);
        System.out.println("\n ~ Results : ~ \n");
        System.out.println("Check transformPolicyObj attributs value : \n ");
        Assert.assertNotNull((Object)transformPolicyObj);
        Element styleSheetAsElement = transformPolicyObj.getStyleSheet();
        Assert.assertNotNull((Object)styleSheetAsElement);
        System.out.println("xslt stylesheet for policy transformation :\n" + XMLPrettyPrinter.prettyPrint((Document)styleSheetAsElement.getOwnerDocument()) + "\n");
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testWriteTransformPolicy() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testWriteTransformPolicy() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/TransformPolicy.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        XsltStyleSheetType transformPolicyAsObj = WSNotificationExtensionReader.getInstance().readXsltStyleSheetType(docDesc);
        Assert.assertNotNull((Object)transformPolicyAsObj);
        System.out.println("\n ~ Results : ~ \n");
        Document transformPolicyAsDoc = WSNotificationExtensionWriter.getInstance().writeXsltStyleSheetType(transformPolicyAsObj);
        Assert.assertNotNull((Object)transformPolicyAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)transformPolicyAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~~~ \n");
    }

    public void testCreateTransformPolicy() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testCreateTransformPolicy() method output results : ~~\n");
        XsltStyleSheetType transformPolicyAsObj = WSNotificationExtensionFactory.getInstance().createXsltStyleSheetType();
        Assert.assertNotNull((Object)transformPolicyAsObj);
        Document stylesheetAsDoc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/stylesheetSample.xsl"));
        transformPolicyAsObj.setStyleSheet(stylesheetAsDoc.getDocumentElement());
        System.out.println("\n ~ Results : ~ \n");
        Document transformPolicyAsDoc = WSNotificationExtensionWriter.getInstance().writeXsltStyleSheetType(transformPolicyAsObj);
        Assert.assertNotNull((Object)transformPolicyAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)transformPolicyAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testReadTerminationTime() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testReadTerminationTime() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/TerminationTime.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        TerminationTimeType terminationTimeObj = WSNotificationExtensionReader.getInstance().readTerminationTimeType(docDesc);
        System.out.println("\n ~ Results : ~ \n");
        System.out.println("Check terminationTimeObj attributs value : \n ");
        Assert.assertNotNull((Object)terminationTimeObj);
        Date terminationTimeAsDate = terminationTimeObj.getValue();
        Assert.assertNotNull((Object)terminationTimeAsDate);
        System.out.println("xslt Termination Time Date :\n" + terminationTimeAsDate.toString() + "\n");
        System.out.println("\n ~~~~~~~~~~~ \n");
    }

    public void testWriteTerminationTime() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testWriteTerminationTime() method output results : ~~\n");
        Document docDesc = this.convertFromStreamToDocument(TestWSNotificationExtension.class.getResourceAsStream("/TerminationTime.xml"));
        System.out.println("Xml file imported (input test parameters) :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc) + "\n");
        TerminationTimeType terminationTimeAsObj = WSNotificationExtensionReader.getInstance().readTerminationTimeType(docDesc);
        Assert.assertNotNull((Object)terminationTimeAsObj);
        System.out.println("\n ~ Results : ~ \n");
        Document terminationTimeAsDoc = WSNotificationExtensionWriter.getInstance().writeTerminationTimeType(terminationTimeAsObj);
        Assert.assertNotNull((Object)terminationTimeAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)terminationTimeAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~~~ \n");
    }

    public void testCreateTerminationTime() throws WSNotificationExtensionException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("\n\t ~~ testCreateTerminationTime() method output results : ~~\n");
        TerminationTimeType terminationTimeAsObj = WSNotificationExtensionFactory.getInstance().createTerminationTimeType();
        Assert.assertNotNull((Object)terminationTimeAsObj);
        GregorianCalendar gCalendar = new GregorianCalendar();
        terminationTimeAsObj.setValue(gCalendar.getTime());
        System.out.println("\n ~ Results : ~ \n");
        Document terminationTimeAsDoc = WSNotificationExtensionWriter.getInstance().writeTerminationTimeType(terminationTimeAsObj);
        Assert.assertNotNull((Object)terminationTimeAsDoc);
        System.out.println("result displayed as xml document :\n" + XMLPrettyPrinter.prettyPrint((Document)terminationTimeAsDoc) + "\n");
        System.out.println("\n ~~~~~~~~~~~ \n");
    }
}

