/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.CreatePullPoint;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.CreatePullPointResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.impl.CreatePullPointMgr;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.impl.NotificationProducerMgr;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.impl.PullPointMgr;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.impl.SubscriptionManagerMgr;
import com.ebmwebsourcing.wsstar.notification.service.brokerednotification.WsnbrNotificationBroker;
import com.ebmwebsourcing.wsstar.notification.service.brokerednotification.WsnbrPublisherRegistrationManager;
import com.ebmwebsourcing.wsstar.notification.service.brokerednotification.impl.RegistrationsMgr;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.persistence.WsnPersistence;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;
import java.io.File;
import java.io.InputStream;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public class BrokeredNotificationService
implements WsnbrNotificationBroker,
WsnbrPublisherRegistrationManager {
    private final String PETALS_NAMESPACE = "http://petals.ow2.org/petals-se-notification";
    private final String persistedRegistrationFolderName = "SavePublisherRegistrationRP" + File.separatorChar;
    private final String persistedSubscriptionFolderName = "SaveSubscriptionManagerRP" + File.separatorChar;
    private final QName NOTIFICATION_BROKER_SERVICE_QNAME = new QName("http://petals.ow2.org/petals-se-notification", "NotificationBrokerService");
    private final QName NOTIFICATION_BROKER_INTERFACE_QNAME = new QName("http://docs.oasis-open.org/wsn/br-2", "NotificationBroker");
    private final String NOTIFICATION_BROKER_ENDPOINT = "NotificationBrokerEndpoint";
    private final QName PUBLISHER_REGISTRATION_MANAGER_SERVICE_QNAME = new QName("http://petals.ow2.org/petals-se-notification", "PublisherRegistrationManagerService");
    private final QName PUBLISHER_REGISTRATION_MANAGER_INTERFACE_QNAME = new QName("http://docs.oasis-open.org/wsn/br-2", "PublisherRegistrationManager");
    private final String PUBLISHER_REGISTRATION_MANAGER_ENDPOINT = "PublisherRegistrationManagerEndpoint";
    private final QName SUBSCRIPTION_MANAGER_SERVICE_QNAME = new QName("http://petals.ow2.org/petals-se-notification", "SubscriptionManagerService");
    private final QName SUBSCRIPTION_MANAGER_INTERFACE_QNAME = new QName("http://docs.oasis-open.org/wsn/b-2", "SubscriptionManager");
    private final String SUBSCRIPTION_MANAGER_ENDPOINT = "SubscriptionManagerEndpoint";
    public Logger logger = null;
    private NotificationProducerMgr wsnbProducerService = null;
    private SubscriptionManagerMgr wsnbSubscriptionManagerService = null;
    private RegistrationsMgr wsnbrRegistrationMgr = null;
    private CreatePullPointMgr wsnbCreatePullPointService = null;
    private PullPointMgr wsnbPullPointService = null;
    private WstopTopicManager wstopTopicsMgr = null;
    private WsnPersistence wsnPersistenceMgr = new WsnPersistence(new File("tmp" + File.separatorChar + this.persistedSubscriptionFolderName), new File("tmp" + File.separatorChar + this.persistedRegistrationFolderName));

    public BrokeredNotificationService(Logger logger, InputStream supportedTopicsConfig) {
        this.wstopTopicsMgr = new WstopTopicManager(supportedTopicsConfig);
        this.wsnbSubscriptionManagerService = new SubscriptionManagerMgr(logger, this.wstopTopicsMgr, this.wsnPersistenceMgr);
        this.wsnbSubscriptionManagerService.setSubscriptionsManagerEdp("SubscriptionManagerEndpoint");
        this.wsnbSubscriptionManagerService.setSubscriptionsManagerInterface(this.SUBSCRIPTION_MANAGER_INTERFACE_QNAME);
        this.wsnbSubscriptionManagerService.setSubscriptionsManagerService(this.SUBSCRIPTION_MANAGER_SERVICE_QNAME);
        this.wsnbProducerService = new NotificationProducerMgr(logger, this.wstopTopicsMgr, this.wsnbSubscriptionManagerService);
        this.wsnbProducerService.setNotificationProducerEdp("NotificationBrokerEndpoint");
        this.wsnbProducerService.setNotificationProducerService(this.NOTIFICATION_BROKER_SERVICE_QNAME);
        this.wsnbProducerService.setNotificationProducerInterface(this.NOTIFICATION_BROKER_INTERFACE_QNAME);
        this.wsnbrRegistrationMgr = new RegistrationsMgr(logger, this.wstopTopicsMgr, this.wsnPersistenceMgr);
        this.wsnbrRegistrationMgr.setPublisherRegistrationMgrServiceQName(this.PUBLISHER_REGISTRATION_MANAGER_SERVICE_QNAME);
        this.wsnbrRegistrationMgr.setPublisherRegistrationMgrEdpAddress("PublisherRegistrationManagerEndpoint");
        this.wsnbrRegistrationMgr.setPublisherRegistrationMgrInterfaceQName(this.PUBLISHER_REGISTRATION_MANAGER_INTERFACE_QNAME);
        this.wsnbPullPointService = new PullPointMgr(logger);
        this.wsnbCreatePullPointService = new CreatePullPointMgr(logger, this.wsnbPullPointService);
    }

    public void restorePreviousState() throws WSNotificationException, WSNotificationFault {
        this.wsnbSubscriptionManagerService.restorePersistedSubscriptions();
        this.wsnbrRegistrationMgr.restorePersistedRegistration();
    }

    public WstopTopicManager getWstopTopicsMgr() {
        return this.wstopTopicsMgr;
    }

    public void notify(Notify request) throws WSNotificationExtensionException {
        System.out.println("I am the \"notification broker\" and i have received a notification from a registred notification producer !");
        System.out.println("I must forward this notification to all consumer that have subscribed to it");
        try {
            EndpointReferenceType newNotificationMsgOwner = WSAddressingFactory.getInstance().newEndpointReferenceType();
            ReferenceParametersType refParam = (ReferenceParametersType)newNotificationMsgOwner.newReferenceParameters();
            SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
            soaParam.setEndpoint(this.wsnbProducerService.getNotificationProducerEdp());
            soaParam.setService(this.wsnbProducerService.getNotificationProducerService());
            soaParam.setInterface(this.wsnbProducerService.getNotificationProducerInterfaceQName());
            WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)refParam);
            newNotificationMsgOwner.setAddress("http://petals.ow2.org/cdk");
            newNotificationMsgOwner.setReferenceParameters((AbsItfReferenceParametersType)refParam);
            List messages = request.getNotificationMessage();
            for (NotificationMessageHolderType msg : messages) {
                System.out.println("\nNotification message content : " + msg.getMessage());
                TopicExpressionType topic = msg.getTopic();
                for (QName nsToDisplay : topic.getTopicNameSpace()) {
                    System.out.println("Topic namespace : " + nsToDisplay.toString());
                }
                System.out.println("Topic dialect : " + topic.getDialect());
                System.out.println("Topic content : " + topic.getContent());
                List subscriptionIds = this.wstopTopicsMgr.getSubscriptionIdsFromTopicsSet(topic, true);
                System.out.println("This is the list of customers to notify (forward the received notification) : ");
                EndpointReferenceType currentConsumerEdp = null;
                TerminationTimeType currentTermTime = null;
                for (String subsId : subscriptionIds) {
                    currentTermTime = this.wsnbSubscriptionManagerService.getTerminationTimeOfSubscription(subsId);
                    if (currentTermTime == null || currentTermTime.getValue().after(new GregorianCalendar().getTime())) {
                        currentConsumerEdp = this.wsnbSubscriptionManagerService.getConsumerEdpRefOfSubscription(subsId);
                        msg.setSubscriptionReference(currentConsumerEdp);
                        if (currentConsumerEdp == null) continue;
                        newNotificationMsgOwner.setAddress(currentConsumerEdp.getAddress());
                        String targetEdp = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)((ReferenceParametersType)currentConsumerEdp.getReferenceParameters())).getEndpoint();
                        System.out.println("Target consumer Endpoint to notify : " + targetEdp);
                        msg.setProducerReference(newNotificationMsgOwner);
                        System.out.println("\n And its associated payload notification : ");
                        Document requestAsDocument = WSNotificationWriter.getInstance().writeNotify(request);
                        System.out.println(" *** xml file (request) imported :\n" + XMLPrettyPrinter.prettyPrint((Document)requestAsDocument) + "\n");
                        continue;
                    }
                    if (currentTermTime.getValue().after(new GregorianCalendar().getTime())) continue;
                    this.wsnbSubscriptionManagerService.removeExpiredSubscription(subsId);
                }
            }
        }
        catch (WSNotificationException e) {
            e.printStackTrace();
        }
        catch (WSAddressingException e) {
            e.printStackTrace();
        }
    }

    public RegisterPublisherResponse registerPublisher(RegisterPublisher request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        RegisterPublisherResponse result = this.wsnbrRegistrationMgr.registerPublisher(request);
        try {
            EndpointReferenceType newSubscribeMsgOwner = WSAddressingFactory.getInstance().newEndpointReferenceType();
            ReferenceParametersType refParam = (ReferenceParametersType)newSubscribeMsgOwner.newReferenceParameters();
            SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
            soaParam.setEndpoint(this.wsnbProducerService.getNotificationProducerEdp());
            soaParam.setService(this.wsnbProducerService.getNotificationProducerService());
            soaParam.setInterface(this.wsnbProducerService.getNotificationProducerInterfaceQName());
            WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)refParam);
            newSubscribeMsgOwner.setAddress("http://petals.ow2.org/cdk");
            newSubscribeMsgOwner.setReferenceParameters((AbsItfReferenceParametersType)refParam);
            String targetEdp = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)((ReferenceParametersType)request.getPublisherReference().getReferenceParameters())).getEndpoint();
            System.out.println("target producer Endpoint which a susbcribe request must be sent to : " + targetEdp + "\n");
            List topExprs = request.getTopic();
            for (TopicExpressionType topicExprItem : topExprs) {
                List subsIds = this.wstopTopicsMgr.getSubscriptionIdsFromTopicsSet(topicExprItem, false);
                System.out.println("list of consumers subscribed which want to be notified : ");
                for (String subsIdItem : subsIds) {
                    System.out.println("subscriptionId : " + subsIdItem);
                    Subscribe subscriptionPayload = WSNotificationFactory.getInstance().createSubscribe();
                    ResourcesUuidType resourcesUuid = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
                    resourcesUuid.addUuid(subsIdItem);
                    WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)resourcesUuid, (ReferenceParametersType)((ReferenceParametersType)newSubscribeMsgOwner.getReferenceParameters()));
                    EndpointReferenceType subscribedConsumerEdp = this.wsnbSubscriptionManagerService.getConsumerEdpRefOfSubscription(subsIdItem);
                    newSubscribeMsgOwner.setAddress(subscribedConsumerEdp.getAddress());
                    subscriptionPayload.setConsumerReference(newSubscribeMsgOwner);
                    FilterType filterToSet = this.wsnbSubscriptionManagerService.getFilterOfSubscription(subsIdItem);
                    subscriptionPayload.setFilter(filterToSet);
                    subscriptionPayload.setSubscriptionPolicy(this.wsnbSubscriptionManagerService.getPolicyOfSubscription(subsIdItem));
                    Document requestAsDocument = WSNotificationWriter.getInstance().writeSubscribe(subscriptionPayload);
                    System.out.println("\n Forwarded subscription payload : ");
                    System.out.println(" *** xml file (request) content :\n" + XMLPrettyPrinter.prettyPrint((Document)requestAsDocument) + "\n");
                }
            }
        }
        catch (WSAddressingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public DestroyRegistrationResponse destroyRegistration(DestroyRegistration request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        return this.wsnbrRegistrationMgr.destroyRegistration(request);
    }

    public SubscribeResponse subscribe(Subscribe request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        SubscribeResponse result = this.wsnbProducerService.subscribe(request);
        try {
            String subsId = (String)WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)((ReferenceParametersType)result.getSubscriptionReference().getReferenceParameters())).getUuids().get(0);
            EndpointReferenceType newSubscribeMsgOwner = WSAddressingFactory.getInstance().newEndpointReferenceType();
            ReferenceParametersType refParam = (ReferenceParametersType)newSubscribeMsgOwner.newReferenceParameters();
            SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
            soaParam.setEndpoint(this.wsnbProducerService.getNotificationProducerEdp());
            soaParam.setService(this.wsnbProducerService.getNotificationProducerService());
            soaParam.setInterface(this.wsnbProducerService.getNotificationProducerInterfaceQName());
            WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)refParam);
            newSubscribeMsgOwner.setAddress(request.getConsumerReference().getAddress());
            newSubscribeMsgOwner.setReferenceParameters((AbsItfReferenceParametersType)refParam);
            List registrationIds = this.wstopTopicsMgr.getRegistrationIdsFromTopicsSet(request.getFilter().getTopicExpression());
            System.out.println("This is the list of Producer to susbcribe to (forward the received consumer subscription) : \n");
            EndpointReferenceType currentProducerEdp = null;
            for (String regId : registrationIds) {
                currentProducerEdp = this.wsnbrRegistrationMgr.getPublisherEdpRefOfRegistration(regId);
                if (currentProducerEdp == null) continue;
                String targetEdp = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)((ReferenceParametersType)currentProducerEdp.getReferenceParameters())).getEndpoint();
                System.out.println("target producer Endpoint to notify : " + targetEdp + "\n");
                ResourcesUuidType resourceUuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
                resourceUuids.addUuid(subsId);
                WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)resourceUuids, (ReferenceParametersType)((ReferenceParametersType)newSubscribeMsgOwner.getReferenceParameters()));
                request.setConsumerReference(newSubscribeMsgOwner);
                Document requestAsDocument = WSNotificationWriter.getInstance().writeSubscribe(request);
                System.out.println("\n Forwarded subscribe request payload : ");
                System.out.println(" *** xml file (request) content :\n" + XMLPrettyPrinter.prettyPrint((Document)requestAsDocument) + "\n");
            }
        }
        catch (WSAddressingException e) {
            throw new WSNotificationException((Throwable)e);
        }
        return result;
    }

    public UnsubscribeResponse unsubscribe(Unsubscribe cancellation) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        UnsubscribeResponse result = null;
        try {
            HashMap<String, List> registrationsPerSubscription = new HashMap<String, List>();
            List subscriptionIds = null;
            ResourcesUuidType uuids = WsnSpecificTypeHelper.getResourcesUuidType((Unsubscribe)cancellation);
            if (uuids != null && (subscriptionIds = uuids.getUuids()) != null) {
                for (String subsId : subscriptionIds) {
                    TopicExpressionType associatedTopicExpression = this.wsnbSubscriptionManagerService.getTopicExpressionOfSubscription(subsId);
                    if (associatedTopicExpression == null) continue;
                    List registrationIds = this.wstopTopicsMgr.getRegistrationIdsFromTopicsSet(associatedTopicExpression);
                    registrationsPerSubscription.put(subsId, this.wsnbrRegistrationMgr.getPublisherEdpRefOfRegistration(registrationIds));
                }
            }
            result = this.wsnbSubscriptionManagerService.unsubscribe(cancellation);
            if (subscriptionIds != null) {
                for (String subsId : subscriptionIds) {
                    List registrationIds = (List)registrationsPerSubscription.get(subsId);
                    if (registrationIds == null) continue;
                    System.out.println("This is the list of Producer to unsusbcribe to (forward the received consumer unsubscribe requet) : \n");
                    for (EndpointReferenceType regRefItem : registrationIds) {
                        String targetEdp = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)((ReferenceParametersType)regRefItem.getReferenceParameters())).getEndpoint();
                        System.out.println("target producer Endpoint whom the unsubscribe request must be forwarded to : " + targetEdp + "\n");
                        Document requestAsDocument = WSNotificationWriter.getInstance().writeUnsubscribe(cancellation);
                        System.out.println("\n Forwarded un-subscription payload : ");
                        System.out.println(" *** xml file (request) content :\n" + XMLPrettyPrinter.prettyPrint((Document)requestAsDocument) + "\n");
                    }
                }
            }
        }
        catch (WSAddressingException e) {
            throw new WSNotificationException((Throwable)e);
        }
        return result;
    }

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage request) throws WSNotificationException, WSNotificationFault {
        return this.wsnbProducerService.getCurrentMessage(request);
    }

    public void setCurrentNotifyMessage(TopicExpressionType topic, Message msg) throws WSNotificationException, WSNotificationFault {
        this.wsnbProducerService.setCurrentMessage(topic, msg);
    }

    public RenewResponse renew(Renew request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        return this.wsnbSubscriptionManagerService.renew(request);
    }

    public CreatePullPointResponse createPullPoint(CreatePullPoint request) throws WSNotificationException, WSNotificationFault {
        return this.wsnbCreatePullPointService.createPullPoint(request);
    }
}

