/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.basenotification.impl;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbNotificationProducer;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.impl.SubscriptionManagerMgr;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;
import com.ebmwebsourcing.wsstar.notification.service.util.WSNotificationTopicManagerBadUsageException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class NotificationProducerMgr
implements WsnbNotificationProducer {
    private Logger logger;
    private String notificationProducerEdp = "http://www.ebmwebsourcing.com/subscriptionManager/default";
    private QName notificationProducerService = new QName("http://www.ebmwebsourcing.com/default", "NotificationProducerService");
    private QName notificationProducerInterface = new QName("http://www.ebmwebsourcing.com/default", "NotificationProducer");
    private WstopTopicManager topicsMgr;
    private SubscriptionManagerMgr subsMgr;
    private Map<String, Message> notifMessageContentList = null;

    public NotificationProducerMgr(Logger logger, WstopTopicManager topicsMgr, SubscriptionManagerMgr subsMgr) {
        this.logger = logger;
        this.topicsMgr = topicsMgr;
        this.subsMgr = subsMgr;
        this.notifMessageContentList = new ConcurrentHashMap<String, Message>();
    }

    public NotificationProducerMgr(Logger logger, SubscriptionManagerMgr subsMgr) {
        this.logger = logger;
        this.topicsMgr = null;
        this.subsMgr = subsMgr;
        this.notifMessageContentList = new ConcurrentHashMap<String, Message>();
    }

    public void setNotificationProducerEdp(String notificationProducerEdp) {
        this.notificationProducerEdp = notificationProducerEdp;
    }

    public String getNotificationProducerEdp() {
        return this.notificationProducerEdp;
    }

    public void setNotificationProducerService(QName notificationProducerService) {
        this.notificationProducerService = notificationProducerService;
    }

    public QName getNotificationProducerService() {
        return this.notificationProducerService;
    }

    public void setNotificationProducerInterface(QName notificationProducerInterface) {
        this.notificationProducerInterface = notificationProducerInterface;
    }

    public QName getNotificationProducerInterfaceQName() {
        return this.notificationProducerInterface;
    }

    public WstopTopicManager getTopicsMgr() {
        return this.topicsMgr;
    }

    public void setTopicsMgr(WstopTopicManager topicsMgr) {
        this.topicsMgr = topicsMgr;
    }

    public SubscriptionManagerMgr getSubsMgr() {
        return this.subsMgr;
    }

    @Override
    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage request) throws WSNotificationException, WSNotificationFault {
        this.logger.log(Level.FINE, "performs a \"GetCurrentMessage\" request ...");
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "subscribe()");
        }
        GetCurrentMessageResponse response = null;
        TopicExpressionType topic = request.getTopic();
        String curMegUuid = this.topicsMgr.getNotifContentUuid(topic, false);
        Message msg = this.notifMessageContentList.get(curMegUuid);
        response = WSNotificationFactory.getInstance().createGetCurrentMessageResponse();
        response.setNotifMessageContent(msg);
        return response;
    }

    public void setCurrentMessage(TopicExpressionType topic, Message notifMessage) throws WSNotificationException, WSNotificationFault {
        String currentMessageUuid = this.topicsMgr.getNotifContentUuid(topic, true);
        if (currentMessageUuid == null || currentMessageUuid.length() == 0) {
            currentMessageUuid = UUID.randomUUID().toString();
        }
        this.topicsMgr.storeNotifContentUuid(topic, currentMessageUuid);
        this.notifMessageContentList.put(currentMessageUuid, notifMessage);
    }

    @Override
    public SubscribeResponse subscribe(Subscribe request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        this.logger.log(Level.FINE, "performs a \"Subscribe\" request ...");
        this.logger.log(Level.FINE, "\"Subscribe\" method implementation in progress !");
        if (this.topicsMgr == null) {
            throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(), "subscribe()");
        }
        SubscribeResponse reponse = null;
        TopicExpressionType topic = request.getFilter().getTopicExpression();
        try {
            ResourcesUuidType rUuids;
            String subscriptionId = "";
            subscriptionId = request.getConsumerReference().getReferenceParameters() != null ? ((rUuids = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)((ReferenceParametersType)request.getConsumerReference().getReferenceParameters()))) != null && rUuids.getUuids().size() == 1 ? (String)rUuids.getUuids().get(0) : UUID.randomUUID().toString()) : UUID.randomUUID().toString();
            this.topicsMgr.storeNewSubscription(topic, subscriptionId);
            EndpointReferenceType subsRef = this.subsMgr.createAndStoreSubscriptionResource(subscriptionId, request);
            reponse = WSNotificationFactory.getInstance().createSubscribeResponse();
            reponse.setSubscriptionReference(subsRef);
        }
        catch (WSAddressingException e) {
            throw new WSNotificationException((Throwable)e);
        }
        catch (WSNotificationFault fault) {
            throw fault;
        }
        return reponse;
    }
}

