/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.fault;

import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationJAXBContext;
import com.ebmwebsourcing.wsstar.resource.definition.basefaults.api.BaseFaultType;
import com.ebmwebsourcing.wsstar.resource.definition.utils.WSResourceException;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class WSNotificationFault
extends Exception {
    private static final long serialVersionUID = 1L;
    protected BaseFaultType wsnFault;

    public WSNotificationFault() {
    }

    public WSNotificationFault(BaseFaultType fault) {
        this.wsnFault = fault;
    }

    protected void init(String lang, String descContent) throws WSNotificationException {
        try {
            this.wsnFault.setDescriptionLanguage(lang);
            this.wsnFault.setDescriptionValue(descContent);
        }
        catch (WSResourceException e1) {
            throw new WSNotificationException((Throwable)e1);
        }
        GregorianCalendar gCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
            this.wsnFault.setTimestamp(xmlCalendar);
        }
        catch (DatatypeConfigurationException e) {
            throw new WSNotificationException((Throwable)e);
        }
    }

    public void setWsnFault(BaseFaultType wsnFault) {
        this.wsnFault = wsnFault;
    }

    public BaseFaultType getWsnFault() {
        return this.wsnFault;
    }

    public Document getDocumentFragment() throws WSNotificationException {
        Document result = null;
        try {
            result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Marshaller marshellar = new WSNotificationJAXBContext().getJaxbContext().createMarshaller();
            marshellar.marshal(this.createJAXBElem(), (Node)result);
        }
        catch (ParserConfigurationException e) {
            throw new WSNotificationException((Throwable)e);
        }
        catch (WSNotificationException e) {
            throw new WSNotificationException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new WSNotificationException((Throwable)e);
        }
        return result;
    }

    protected abstract JAXBElement<?> createJAXBElem() throws WSNotificationException;
}

