/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.topic;

import com.ebmwebsourcing.wsstar.legacy.jaxb.core.NamespaceMapperImpl;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class XPathAnalyzer {
    private static Logger log = Logger.getLogger(XPathAnalyzer.class.getName());

    public synchronized List<?> evaluate(String xpathExpression, Element source, NamespaceMapperImpl context) throws WSNotificationException {
        ArrayList<String> xpathExpressions = new ArrayList<String>();
        xpathExpressions.add(xpathExpression);
        return this.evaluate(xpathExpressions, source, context);
    }

    private List<?> evaluate(List<String> xpathExpressions, Element source, NamespaceMapperImpl context) throws WSNotificationException {
        List target = null;
        try {
            if (source != null) {
                for (String xpathExpression : xpathExpressions) {
                    XPath engine = XPath.newInstance((String)xpathExpression);
                    for (Map.Entry entry : context.getNamespaces().entrySet()) {
                        engine.addNamespace((String)entry.getKey(), (String)entry.getValue());
                    }
                    List res = engine.selectNodes((Object)source);
                    if (!(res instanceof List)) continue;
                    target = res;
                    if (!log.isLoggable(Level.FINE)) break;
                    log.fine("this xpath expression " + xpathExpression + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
                    break;
                }
                if (target == null && log.isLoggable(Level.FINE)) {
                    log.fine("No xpath expressions " + xpathExpressions + " match with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
                }
            }
        }
        catch (JDOMException e) {
            throw new WSNotificationException((Throwable)e);
        }
        return target;
    }
}

