/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.qml.test;

import com.ebmwebsourcing.wsstar.qml.WSQMLFactory;
import com.ebmwebsourcing.wsstar.qml.api.Constraint;
import com.ebmwebsourcing.wsstar.qml.api.EquivalentTo;
import com.ebmwebsourcing.wsstar.qml.api.QOSDimension;
import com.ebmwebsourcing.wsstar.qml.api.Type;
import com.ebmwebsourcing.wsstar.qml.api.Unit;
import com.ebmwebsourcing.wsstar.qml.api.Value;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;

public class TestWSQMLDescriptor
extends TestCase {
    private String TARGET_NAMESPACE = "http://petals.ow2.org/";

    public QName cName(String name) {
        return new QName(this.TARGET_NAMESPACE, name);
    }

    public TestWSQMLDescriptor(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReaderQOSDimension() throws URISyntaxException, WSQMLException {
        QOSDimension desc = WSQMLFactory.newInstance().newWSQMLReader().readQOSDimension(new URI("./src/test/resources/descriptors/qosDimension.xml"));
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((String)"http://tempuri.org", (String)desc.getSemanticConcept());
        System.out.println(desc);
        System.out.println(desc.getSemanticConcept());
    }

    public void testWriterQOSDimension() throws URISyntaxException, WSQMLException {
        QOSDimension desc = WSQMLFactory.newInstance().newWSQMLReader().readQOSDimension(new URI("./src/test/resources/descriptors/qosDimension.xml"));
        String res = WSQMLFactory.newInstance().newWSQMLWriter().writeQOSDimension(desc);
        System.out.println("xml plat:\n" + res);
        Assert.assertNotNull((Object)res);
        Document doc = WSQMLFactory.newInstance().newWSQMLWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
    }

    public void testCreateQOSDimension() throws URISyntaxException, WSQMLException {
        QOSDimension desc = WSQMLFactory.newInstance().newQOSDimension();
        desc.setOntology("http://www.myontology/");
        desc.setSemanticConcept("myConcept");
        Assert.assertNotNull((Object)desc);
        Document doc = WSQMLFactory.newInstance().newWSQMLWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
    }

    public void testReaderConstraint() throws URISyntaxException, WSQMLException {
        Constraint desc = WSQMLFactory.newInstance().newWSQMLReader().readConstraint(new URI("./src/test/resources/descriptors/constraint.xml"));
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((String)"==", (String)desc.getOperator());
        System.out.println(desc);
        System.out.println(desc.getOperator());
    }

    public void testWriterConstraint() throws URISyntaxException, WSQMLException {
        Constraint desc = WSQMLFactory.newInstance().newWSQMLReader().readConstraint(new URI("./src/test/resources/descriptors/constraint.xml"));
        String res = WSQMLFactory.newInstance().newWSQMLWriter().writeConstraint(desc);
        System.out.println("xml plat:\n" + res);
        Assert.assertNotNull((Object)res);
        Document doc = WSQMLFactory.newInstance().newWSQMLWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
    }

    public void testCreateConstraint() throws URISyntaxException, WSQMLException {
        Constraint desc = WSQMLFactory.newInstance().newConstraint();
        desc.setOperator("&lt;");
        Value val = desc.newValue();
        desc.setValue(val);
        val.setValue(new Float(0.2));
        Unit u = val.newUnit();
        val.setUnit(u);
        u.setName("sec");
        u.setSemanticConcept("http://www.w3.org/2007/ont/unit#s");
        Type t = val.newType();
        val.setType(t);
        t.setName("decimal");
        t.setSemanticConcept("http://www.w3c.org/2001/XMLSchema:decimal");
        Assert.assertNotNull((Object)desc);
        Document doc = WSQMLFactory.newInstance().newWSQMLWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
    }

    public void testReaderEquivalentTo() throws URISyntaxException, WSQMLException {
        EquivalentTo desc = WSQMLFactory.newInstance().newWSQMLReader().readEquivalentTo(new URI("./src/test/resources/descriptors/equivalentTo.xml"));
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((Object)new Float(1.0), (Object)desc.getConversion().getExpr().getExprBinary().getFirstOperand().getValue().getValue());
        System.out.println(desc);
        System.out.println(desc.getConversion());
        System.out.println(desc.getConversion().getFromUnit());
        System.out.println(desc.getConversion().getFromUnit().getName());
        System.out.println(desc.getConversion().getToUnit());
        System.out.println(desc.getConversion().getExpr());
        System.out.println(desc.getConversion().getExpr().getExprBinary());
        System.out.println(desc.getConversion().getExpr().getExprBinary().getBinary());
        System.out.println(desc.getConversion().getExpr().getExprBinary().getFirstOperand());
        System.out.println(desc.getConversion().getExpr().getExprBinary().getFirstOperand().getValue().getValue());
        System.out.println(desc.getConversion().getExpr().getExprBinary().getSecondOperand());
        System.out.println(desc.getConversion().getExpr().getExprBinary().getSecondOperand().getInput());
    }
}

