package com.ebmwebsourcing.wsagreement10.api.type;



public enum ServiceRoleType {

	SERVICE_CONSUMER("ServiceConsumer"),
    SERVICE_PROVIDER("ServiceProvider");
	
	private final String value;

	ServiceRoleType(String v) {
		value = v;
	}

	public String value() {
		return value;
	}

	public static ServiceRoleType fromValue(String v) {
		for (ServiceRoleType c: ServiceRoleType.values()) {
			if (c.value.equals(v)) {
				return c;
			}
		}
		throw new IllegalArgumentException(v);
	}
}