package com.ebmwebsourcing.wsagreement10.api.type;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.wsagreement10.api.element.GuaranteeTerm;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceDescriptionTerm;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceProperties;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceReference;

public interface TermCompositorType extends XmlObject {



	ServiceDescriptionTerm[] getServiceDescriptionTerms();

    void addServiceDescriptionTerm(ServiceDescriptionTerm to);

    void removeServiceDescriptionTerm(ServiceDescriptionTerm to);

    void clearServiceDescriptionTerms();

    ServiceDescriptionTerm getServiceDescriptionTermByName(String name);

    
    
    GuaranteeTerm[] getGuaranteeTerms();

    void addGuaranteeTerm(GuaranteeTerm to);

    void removeGuaranteeTerm(GuaranteeTerm to);

    void clearGuaranteeTerms();

    GuaranteeTerm getGuaranteeTermByName(String name);
    
    
    
    ServiceProperties[] getServiceProperties();

    void addServiceProperties(ServiceProperties to);

    void removeServiceProperties(ServiceProperties to);

    void clearServiceProperties();

    ServiceProperties getServicePropertiesByName(String name);
    
    
    
    ServiceReference[] getServiceReferences();

    void addServiceReference(ServiceReference to);

    void removeServiceReference(ServiceReference to);

    void clearServiceReferences();

    ServiceReference getServiceReferenceByName(String name);
    
    
}
